/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.json.JSONUtil;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.DcDataSourceInfoMapper;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class SnDescriptionProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(SnDescriptionProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 15;
    private static DcDataSourceInfoMapper dcDataSourceInfoMapper;

    @Autowired
    public void setDcDataSourceInfoMapper(DcDataSourceInfoMapper dcDataSourceInfoMapper) {
        SnDescriptionProcessorWithSelfDriver.dcDataSourceInfoMapper = dcDataSourceInfoMapper;
    }

    public static Map<String, Object> process(RemoteWebDriver driver, Goods paramTo) {
        String goodsNo = paramTo.getGoodsNo();
        String url = paramTo.getUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Goods goods = new Goods(MallType.Sn.getCode(), goodsNo);
        GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = new GoodsDetailsWithBLOBs();
        try {
            goodsDetailsWithBLOBs.setGoodsNo(goodsNo);
            goodsDetailsWithBLOBs.setPrefix(MallType.Sn.getCode());
            goodsDetailsWithBLOBs.setExecutionNumber(paramTo.getExecutionNumber());
            goods.setExecutionNumber(paramTo.getExecutionNumber());
            goods.setCategoryId(paramTo.getCategoryId());
            String[] strings = url.split("[/ : . \\- _ # %]");
            String skuId = strings[7];
            goods.setSkuId(skuId);
            goods.setUrl(url);
            driver.get(url);
            Thread.sleep(1000L);
            SnDescriptionProcessorWithSelfDriver.pageProcess(goodsDetailsWithBLOBs, goods, driver, url);
        }
        catch (Exception e) {
            log.info("\u82cf\u5b81\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        log.info("\u82cf\u5b81\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetailsWithBLOBs);
        return map;
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }

    private static void pageProcess(GoodsDetailsWithBLOBs goodsDetailsWithBLOBs, Goods goods, RemoteWebDriver driver, String url) {
        String branName;
        String two;
        String categoryId;
        String self;
        Html html = SnDescriptionProcessorWithSelfDriver.createHtml(driver.getPageSource());
        if (html.$("div.search404").match()) {
            goods.setSkuState("0");
            log.info("\u82cf\u5b81\u5546\u57ce\u7f16\u53f7{}\u6570\u636e{} \u5df2\u4e0b\u67b6", (Object)goods.getSkuId(), (Object)url);
            return;
        }
        html = SnDescriptionProcessorWithSelfDriver.createHtml(driver.getPageSource());
        String priceStr = html.$("span.mainprice").xpath("///allText()").get();
        if (StringUtils.isEmpty((CharSequence)priceStr)) {
            try {
                WebElement element = driver.findElementByClassName("mainprice");
                priceStr = element.getText();
            }
            catch (Exception e) {
                log.error("\u4e0d\u5b58\u5728\u8be5\u5143\u7d20mainprice", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)priceStr)) {
            if ((priceStr = priceStr.trim()).contains("-")) {
                String[] split = priceStr.split("-");
                priceStr = split[0].replace("\u00a5", "").trim();
            } else {
                priceStr = priceStr.replace("\u00a5", "").trim();
            }
        }
        String title = html.$("#itemDisplayName > li").xpath("///allText()").get();
        String isSelf = html.$("#itemDisplayName > span > li").xpath("///allText()").get();
        if (StringUtils.isNotBlank((CharSequence)isSelf)) {
            if (isSelf.contains("\u81ea\u8425")) {
                goods.setSupplierName("\u81ea\u8425");
            } else {
                self = html.$("div.header-shop-inline > a.header-shop-name").xpath("///allText()").get();
                goods.setSupplierName(self);
            }
        } else {
            self = html.$("div.wrapper-allwidth > div.wrapper.head-shop-wrapper >div.header-shop >div.header-shop-inline > a").xpath("///allText()").get();
            goods.setSupplierName(self);
        }
        String pic = html.$("a.view-img  > img").xpath("///@src").get();
        goods.setPic(pic);
        String catName = html.$("div.wrapper-allwidth > div > div.breadcrumb > div:nth-child(5) > span > a").xpath("///allText()").get();
        String catId = html.$("div.wrapper-allwidth > div > div.breadcrumb > div:nth-child(5) > span > a").xpath("///@href").get();
        if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (two = catId.split("//list.suning.com/0-")[1]).split("-")[0]))) {
            goods.setCategoryId(categoryId);
        }
        if (StringUtils.isNotEmpty((CharSequence)catName)) {
            goods.setCategoryName(catName);
        }
        List nodes = html.$("div.tzm > dl.proattr-radio").nodes();
        String skuSaleAttrNames = "";
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            ArrayList saleAttrList = new ArrayList();
            nodes.forEach(node -> {
                String saleAttr = node.$("dt span").xpath("///allText()").get();
                if (StringUtils.isNotEmpty((CharSequence)saleAttr)) {
                    saleAttrList.add(saleAttr);
                }
            });
            skuSaleAttrNames = String.join((CharSequence)",", saleAttrList);
        }
        String introduce = html.$("div.prod-detail-container").get();
        String skuAttrNames = "";
        String skuAttrJson = "";
        ArrayList attrList = new ArrayList();
        HashMap jsonMap = new HashMap();
        List nodes1 = html.$("table.pro-para-tbl tbody > tr[parametercode]").nodes();
        if (CollectionUtils.isNotEmpty((Collection)nodes1)) {
            nodes1.forEach(node1 -> {
                String attr = node1.$("td.name div.name-inner span").xpath("///allText()").get();
                String attrValue = node1.$("td.val").xpath("///allText()").get();
                if (StringUtils.isEmpty((CharSequence)attr)) {
                    attr = node1.$("td.name").xpath("///allText()").get();
                }
                if (StringUtils.isNotEmpty((CharSequence)attr)) {
                    attrList.add(attr);
                    jsonMap.put(attr, attrValue);
                }
            });
            skuAttrNames = String.join((CharSequence)",", attrList);
            skuAttrJson = JSONUtil.toJsonStr(jsonMap);
        }
        if (StringUtils.isEmpty((CharSequence)(branName = (String)jsonMap.get("\u54c1\u724c")))) {
            branName = html.$("div.breadcrumb").xpath("///div[@role='menuitem']/span[@class='dropdown-text']/a/text()").get();
        }
        goods.setBrandName(branName);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
        if (StringUtils.isNotBlank((CharSequence)priceStr)) {
            goods.setPrice(new BigDecimal(priceStr));
        } else {
            goods.setPrice(new BigDecimal("0"));
        }
        try {
            WebElement check = driver.findElementById("productCommTitle");
            check.click();
            WebElement uncheck = driver.findElementByClassName("uncheck");
            uncheck.click();
            Thread.sleep(500L);
        }
        catch (Exception check) {
            // empty catch block
        }
        html = SnDescriptionProcessorWithSelfDriver.createHtml(driver.getPageSource());
        HashMap<String, String> comment = new HashMap<String, String>();
        List commentstr = html.$("ul.rv-place-item.clearfix>li").nodes();
        if (CollectionUtils.isNotEmpty((Collection)commentstr)) {
            for (int i = 0; i < commentstr.size(); ++i) {
                String attrValue = ((Selectable)commentstr.get(i)).$("a>p>span").xpath("///allText()").get();
                if (!StringUtils.isNotEmpty((CharSequence)attrValue)) continue;
                attrValue = attrValue.replace("(", "").replace(")", "");
                if (i == 0) {
                    comment.put("\u603b\u8bc4\u4ef7\u6570", attrValue);
                }
                if (i == 2) {
                    comment.put("\u6652\u56fe", attrValue);
                }
                if (i == 3) {
                    comment.put("\u597d\u8bc4\u6570", attrValue);
                }
                if (i == 4) {
                    comment.put("\u4e2d\u8bc4\u6570", attrValue);
                }
                if (i == 5) {
                    comment.put("\u5dee\u8bc4\u6570", attrValue);
                }
                if (i != 6) continue;
                comment.put("\u8ffd\u8bc4\u6570", attrValue);
            }
        }
        comment.put("\u597d\u8bc4\u5ea6", "100%");
        String commentStr = "";
        if (comment != null && comment.size() > 0) {
            commentStr = JSONUtil.toJsonStr(comment);
            goodsDetailsWithBLOBs.setComment(commentStr);
        }
        if (StringUtils.isNotBlank((CharSequence)skuAttrJson)) {
            goodsDetailsWithBLOBs.setPrefix(MallType.Sn.getCode());
            goodsDetailsWithBLOBs.setSkuSaleAttrNames(skuSaleAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrNames(skuAttrNames);
            goodsDetailsWithBLOBs.setSkuAttrJson(skuAttrJson);
            goodsDetailsWithBLOBs.setIntroduce(introduce);
            goodsDetailsWithBLOBs.setSkuId(goods.getSkuId());
            log.info("\u82cf\u5b81\u5546\u57ce\u7f16\u53f7{}\u6570\u636e\u89e3\u6790\u6210\u529f", (Object)goods.getSkuId());
        }
    }
}

