/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class StbDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(StbDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String url = goods.getUrl();
        RemoteWebDriver driver = DriverFactory.createDiffDriver(PageLoadStrategy.NORMAL);
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        goodsDetails.setExecutionNumber(goods.getExecutionNumber());
        try {
            driver.get(url);
            driver.executeScript("history.go(0)", new Object[0]);
            PageOperateUtil.pageRefresh(driver);
            Page page0 = PageOperateUtil.createPage(url, driver.getPageSource());
            this.pageProcess(page0, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.info("\u53f2\u6cf0\u535a\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        finally {
            if (driver != null) {
                try {
                    driver.quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", request.getExtra("keyword"));
        log.info("\u53f2\u6cf0\u535a\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        Pattern pattern;
        Matcher matcher;
        String categoryId;
        Html html = page.getHtml();
        HashMap hashMap = new HashMap();
        List div = html.$("div.container-box div.ng-scope").nodes();
        StringBuilder commodityAttribute = new StringBuilder();
        div.forEach(selectable -> {
            String goodsAttribute = selectable.$("span.disblock").xpath("///allText()").get();
            String goodsSaleAttribute = selectable.$("span.part16").xpath("///allText()").get();
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        List brandNameList = html.xpath("//span[@class='part16']").nodes();
        String brandName = null;
        if (CollectionUtils.isNotEmpty((Collection)brandNameList)) {
            brandName = ((Selectable)brandNameList.get(0)).xpath("///allText()").get();
        }
        String price = html.$("div.money.ng-scope >  span:nth-child(1)").xpath("///allText()").get();
        String skuId = html.$("div.price.ng-scope > dl:last-child > dd.ng-binding").xpath("///allText()").get();
        String title = html.$("div.title-text > div > h1").xpath("///allText()").get();
        String pic = html.$("img.item-img.jqzoom-item-img").xpath("///@src").get();
        if (StringUtils.isNotEmpty((CharSequence)pic)) {
            goods.setPic(pic);
        }
        String catName = html.$("#breadcrumb > div > div > a:nth-child(7)").xpath("///allText()").get();
        String catId = html.$("#breadcrumb > div > div > a:nth-child(7)").xpath("///@href").get();
        if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (matcher = (pattern = Pattern.compile("[^0-9]+")).matcher(catId)).replaceAll("").trim()))) {
            goods.setCategoryId(categoryId);
        }
        if (StringUtils.isNotEmpty((CharSequence)catName)) {
            goods.setCategoryName(catName);
        }
        String introduce = html.$("div.prd-tags").get();
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuId(skuId);
        goodsDetails.setPrefix(MallType.Stb.getCode());
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
        goodsDetails.setIntroduce(introduce);
        goods.setPrefix(MallType.Stb.getCode());
        goods.setBrandName(brandName);
        String nonExistent = html.$("span.keywords").get();
        String name = html.xpath("//h1[@class='ng-binding']/text()").get();
        if (nonExistent != null) {
            goods.setSkuState("0");
            log.info("{}\u5546\u54c1\u5df2\u4e0b\u67b6,\u65e0\u6cd5\u83b7\u53d6\u8be6\u60c5", (Object)goods.getGoodsNo());
        }
        if (StringUtils.isNotBlank((CharSequence)price)) {
            String value = price.replace("\uffe5", "");
            goods.setPrice(new BigDecimal(value));
        }
        goods.setSkuId(skuId);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            goods.setTitle(title);
        }
    }

    public Site getSite() {
        return Site.me();
    }
}

