/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.util.TempUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;

@Component
public class XhgjDescriptionProcessor {
    private static final Logger log = LoggerFactory.getLogger(XhgjDescriptionProcessor.class);

    public Map<String, Object> process(Goods goods) {
        String executionNumber = goods.getExecutionNumber();
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        String url = goods.getUrl();
        try {
            HttpResponse response = ((HttpRequest)HttpRequest.get((String)url).header("Content-Type", "application/json")).execute();
            if (!response.isOk()) {
                throw new DcBusinessException("\u83b7\u53d6\u6570\u636e\u5931\u8d25" + JSONUtil.toJsonStr((Object)response));
            }
            String result = response.body();
            Html html = new Html(result);
            goodsDetails.setExecutionNumber(executionNumber);
            this.pageProcess(html, goodsDetails, goods);
            Thread.sleep(200L);
        }
        catch (Exception e) {
            log.error("\u54b8\u4ea8\u5546\u57ce\u5546\u54c1\u7f16\u7801{}\u8be6\u60c5\u5931\u8d25{}", (Object)goods.getGoodsNo(), (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        log.info("\u54b8\u4ea8\u5546\u57ceskuId{}\u8be6\u60c5\u66f4\u65b0\u5b8c\u6bd5", (Object)goods.getSkuId());
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        return map;
    }

    private void pageProcess(Html html, GoodsDetailsWithBLOBs goodsDetails, Goods goods) {
        String[] thirdStrings;
        String categoryId;
        List divs = html.$("div.detail-info-box>div.item").nodes();
        HashMap hashMap = new HashMap();
        StringBuilder commodityAttribute = new StringBuilder();
        divs.forEach(selectable -> {
            String goodsAttributeStr = selectable.xpath("///allText()").get();
            String goodsAttribute = null;
            String goodsSaleAttribute = null;
            if (StringUtils.isNotEmpty((CharSequence)goodsAttributeStr)) {
                String[] att = goodsAttributeStr.split("\uff1a");
                goodsAttribute = att[0];
                if (att.length > 1) {
                    goodsSaleAttribute = att[1];
                }
            }
            commodityAttribute.append(goodsAttribute + ",");
            hashMap.put(goodsAttribute, goodsSaleAttribute);
        });
        String skuAttrJson = JSON.toJSONString(hashMap);
        String brandName = hashMap.get("\u54c1\u724c").toString();
        String price = html.$("div.mall-number > p:nth-child(2) > span.text.red").xpath("///allText()").get();
        String skuId = html.$("div.mall-number > p:nth-child(3) > span:nth-child(2)").xpath("///allText()").get();
        String title = html.$("div.promotionMiddle > div:nth-child(1)").xpath("///allText()").get();
        String title1 = html.$("div.promotionMiddle > div:nth-child(2)").xpath("///allText()").get();
        if (StringUtils.isNotEmpty((CharSequence)title1)) {
            title = title + " " + title1;
        }
        String pic = html.$("#image_box > a").xpath("///@href").get();
        goods.setPic(pic);
        goods.setSupplierName("\u81ea\u8425");
        String catName = html.$("div.local > a:nth-child(5)").xpath("///allText()").get();
        String catId = html.$("div.local > a:nth-child(5)").xpath("///@href").get();
        if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (thirdStrings = catId.split("/list"))[1].replace(".htm", "")))) {
            goods.setCategoryId(categoryId);
        }
        if (StringUtils.isNotEmpty((CharSequence)catName)) {
            goods.setCategoryName(catName);
        }
        if (StringUtils.isNotEmpty((CharSequence)skuId)) {
            goods.setSkuId(skuId);
        }
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            goods.setTitle(title);
        }
        goods.setPrefix(MallType.Xhgj.getCode());
        goods.setBrandName(brandName);
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            goods.setPrice(new BigDecimal(TempUtil.getPrice(price)));
        } else {
            log.info("\u54b8\u4ea8\u5546\u57ce\u7f16\u53f7{}\u5df2\u4e0b\u67b6", (Object)goods.getGoodsNo());
            goods.setSkuState("0");
        }
        goodsDetails.setPrefix(MallType.Xhgj.getCode());
        goodsDetails.setGoodsNo(goods.getGoodsNo());
        goodsDetails.setSkuId(skuId);
        goodsDetails.setSkuAttrNames(commodityAttribute.toString());
        goodsDetails.setSkuAttrJson(skuAttrJson);
        goodsDetails.setCreated(new Date());
    }
}

