/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.description;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class ZkhDescriptionProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZkhDescriptionProcessor.class);

    public void process(Page page) {
        Request request = page.getRequest();
        Goods goods = (Goods)request.getExtra("goods");
        String keyword = (String)request.getExtra("keyword");
        HashMap<String, Object> map = new HashMap<String, Object>();
        GoodsDetailsWithBLOBs goodsDetails = new GoodsDetailsWithBLOBs();
        goodsDetails.setExecutionNumber(goods.getExecutionNumber());
        String url = goods.getUrl();
        try {
            String result = HttpRequest.get((String)url).execute().body();
            Page page0 = PageOperateUtil.createPage(url, result);
            this.pageProcess(page0, goodsDetails, goods);
            Random random = new Random();
            TimeUnit.SECONDS.sleep(random.nextInt(10) + 1);
        }
        catch (Exception e) {
            log.info("zkh\u5546\u57ce\u8be6\u60c5url{}\u5931\u8d25", (Object)url, (Object)e);
            throw new DcBusinessException(e.getMessage());
        }
        map.put("goods", goods);
        map.put("goodsDetails", goodsDetails);
        map.put("keyword", keyword);
        log.info("zkh\u5546\u57ce\u8be6\u60c5url{}\u66f4\u65b0\u5b8c\u6bd5", (Object)url);
        page.putField("map", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageProcess(Page page, GoodsDetailsWithBLOBs goodsDetails, Goods goods) throws InterruptedException {
        String url = page.getUrl().toString();
        SelfDriver selfDriver = null;
        RemoteWebDriver driver = null;
        try {
            String[] stringUrls;
            String categoryId;
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            driver = selfDriver.getDriver();
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            Html html = ZkhDescriptionProcessor.createHtml(driver.getPageSource());
            goods.setUrl(url);
            String title = html.$("div.zkh-prop-wrap > div > h1").xpath("///allText()").get();
            if (StringUtils.isNotEmpty((CharSequence)title)) {
                goods.setTitle(title);
            } else {
                goods.setTitle("\u6ca1\u6709\u6807\u9898");
            }
            List div = html.$("ul.zkh-material-list div.zkh-prop-item").nodes();
            HashMap hashMap = new HashMap();
            StringBuilder commodityAttribute = new StringBuilder();
            div.forEach(selectable -> {
                String goodsAttribute = selectable.$("div.zkh-prop-tit").xpath("///allText()").get();
                String goodsSaleAttribute = selectable.$("div.zkh-prop-info", "title").get();
                commodityAttribute.append(goodsAttribute + ",");
                hashMap.put(goodsAttribute, goodsSaleAttribute);
            });
            String skuAttrJson = JSON.toJSONString(hashMap);
            String brandName = hashMap.get("\u54c1\u724c\u540d\u79f0").toString();
            String introduce = html.$("div.params-wrap").get();
            String price = html.$("div.clearfix.zkh-prop-item.new-customer-discount-item > div.zkh-prop-info > span > b").xpath("///allText()").get();
            if (StringUtils.isNotEmpty((CharSequence)price)) {
                goods.setPrice(new BigDecimal(price));
            } else {
                log.info("\u9707\u5764\u884c\u8be5\u5546\u54c1\u4ef7\u683c\u65e0\u6cd5\u67e5\u770b", (Object)goods.getGoodsNo());
            }
            String[] strings = url.split("[/ : . \\- _ # %]");
            String skuId = strings[7];
            String pic = html.$("div.mouse-event-undertake > img").xpath("///@src").get();
            if (StringUtils.isNotEmpty((CharSequence)pic)) {
                goods.setPic(pic);
            }
            String catName = html.$("div.crumbs-box > div > ul > li:nth-child(4) > a").xpath("///allText()").get();
            String catId = html.$("div.crumbs-box > div > ul > li:nth-child(4) > a").xpath("///@href").get();
            if (StringUtils.isNotEmpty((CharSequence)catId) && StringUtils.isNotEmpty((CharSequence)(categoryId = (stringUrls = catId.split("[/ : . \\- _ # %]"))[stringUrls.length - 2]))) {
                goods.setCategoryId(categoryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)catName)) {
                goods.setCategoryName(catName);
            }
            goodsDetails.setPrefix(MallType.ZKH.getCode());
            goodsDetails.setGoodsNo(goods.getGoodsNo());
            goodsDetails.setSkuId(skuId);
            goodsDetails.setSkuAttrNames(commodityAttribute.toString());
            goodsDetails.setSkuAttrJson(skuAttrJson);
            goodsDetails.setCreated(new Date());
            goodsDetails.setIntroduce(introduce);
            goods.setPrefix(MallType.ZKH.getCode());
            goods.setBrandName(brandName);
            goods.setSkuId(skuId);
        }
        catch (Exception e) {
            log.error("\u9707\u5764\u884c\u5546\u57ce\u8be6\u60c5\u9875\u9762\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (driver != null) {
                driver.quit();
            }
        }
    }

    public Site getSite() {
        return Site.me();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

