/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BzdetProcessor {
    private static final Logger log = LoggerFactory.getLogger(BzdetProcessor.class);
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        BzdetProcessor.isAccurate = isAccurate;
    }

    public static void processor(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        int page = 1;
        ArrayList<Goods> goodsL = new ArrayList<Goods>();
        String keyword = paramTo.getKeyword();
        try {
            int total = BzdetProcessor.processorPage(paramTo, processDataPipeline, goodsL, page, executionNumber);
            if (StringUtils.isNotEmpty((CharSequence)keyword) && total > 1) {
                total = 1;
            }
            for (int i = 1; i < total; ++i) {
                Thread.sleep(200L);
                BzdetProcessor.processorPage(paramTo, processDataPipeline, goodsL, ++page, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u5927\u6c5f\u79d1\u6280\u5546\u57ce\u5206\u7c7b{}\u8bf7\u6c42\u5931\u8d25,\u5f53\u524d\u9875{}", new Object[]{paramTo.getCategoryId(), page, e});
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static int processorPage(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, List<Goods> goodsL, int page, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        int totalPage = 0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        try {
            String result;
            String inputLine;
            String ajaxUrl = "https://b.zdet.net/api/product/search";
            URL obj = new URL(ajaxUrl);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Referer", url);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            con.setDoInput(true);
            con.setDoOutput(true);
            String postData = URLEncoder.encode("keyword", "UTF-8") + "=" + URLEncoder.encode(keyword, "UTF-8") + "&" + URLEncoder.encode("sort", "UTF-8") + "=" + URLEncoder.encode("0", "UTF-8");
            OutputStream outputStream = con.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            writer.write(postData);
            writer.flush();
            writer.close();
            outputStream.close();
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            if (content.toString().length() > 0 && (result = content.toString()) != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                if (object != null) {
                    int total = object.getJSONObject("data").getIntValue("total");
                    totalPage = (int)Math.ceil((double)total / 60.0);
                    JSONArray list = object.getJSONObject("data").getJSONArray("hitResult");
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (int i = 0; i < list.size(); ++i) {
                            JSONObject item = list.getJSONObject(i);
                            String name = item.getString("name");
                            String id = item.getString("id");
                            String picture = item.getString("picture");
                            String price = item.getString("price");
                            String brandId = item.getString("brandId");
                            String brandName = item.getString("brandName");
                            Goods goods = new Goods();
                            goods.setBrandId(brandId);
                            goods.setPrefix(MallType.Bzdet.getCode());
                            goods.setTitle(name);
                            goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                            goods.setGoodsNo(id);
                            goods.setPic(picture);
                            goods.setSkuId(id);
                            goods.setCreated(new Date());
                            goods.setBrandName(brandName);
                            goods.setUrl("https://b.zdet.net/mall/item?id=" + id);
                            goods.setSkuState("1");
                            goods.setExecutionNumber(executionNumber);
                            goodsList.add(goods);
                        }
                    } else {
                        log.info("\u5927\u6c5f\u79d1\u6280\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                    }
                } else {
                    log.info("\u5927\u6c5f\u79d1\u6280\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5927\u6c5f\u79d1\u6280\u5546\u57ce\u722c\u53d6\u5546\u54c1\u5217\u8868\u5931\u8d25{}", (Object)url, (Object)e);
        }
        processDataPipeline.processDataList(goodsList, page, totalPage, keyword);
        goodsL.addAll(goodsList);
        paramTo.setGoods(goodsL);
        return totalPage;
    }
}

