/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class ComixProcessor {
    private static final Logger log = LoggerFactory.getLogger(ComixProcessor.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CategoryPO paramTo, String executionNumber) {
        block23: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            if (url.contains("mro.qx.com")) {
                SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                RemoteWebDriver driver = selfDriver.getDriver();
                try {
                    driver.get(url);
                    TimeUnit.SECONDS.sleep(5L);
                    Html html1 = this.createHtml(driver.getPageSource());
                    ArrayList<Goods> goodsLists = new ArrayList<Goods>();
                    int currentPage = 1;
                    int totalPage = 1;
                    this.pageProcess1(html1, goodsLists, executionNumber, categoryId, categoryName);
                    int finalCurrentPage = currentPage;
                    String finalKeyword = keyword;
                    int finalTotalPage = totalPage;
                    this.processDataPipeline.processDataList(goodsLists, finalTotalPage, finalCurrentPage, keyword);
                    goodsLists.clear();
                }
                catch (Exception e) {
                    log.error("\u9f50\u5fc3\u5de5\u4e1a\u7684\u641c\u7d22\u8bcd\u9875\u9762\u7684\u4e1a\u52a1\u5904\u7406\u5f02\u5e38", (Throwable)e);
                }
                finally {
                    if (driver != null) {
                        try {
                            driver.quit();
                        }
                        catch (Exception e) {
                            log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                        }
                    }
                }
            } else {
                try {
                    HttpResponse httpResponse = HttpRequest.get((String)url).execute();
                    if (httpResponse.isOk()) {
                        Html html = this.createHtml(httpResponse.body());
                        ArrayList<Goods> goodsLists = new ArrayList<Goods>();
                        this.pageProcess(html, goodsLists, executionNumber, categoryId, categoryName);
                        String totalPage = html.$("input#total", "value").toString();
                        int maxSize = 1;
                        if (totalPage == null) break block23;
                        maxSize = Integer.parseInt(totalPage);
                        this.processDataPipeline.processDataList(goodsLists, 1, maxSize, keyword);
                        int finalMaxSize = maxSize;
                        log.info("\u9f50\u5fc3\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)maxSize);
                        if (StringUtils.isNotEmpty((CharSequence)keyword) && maxSize > 1) {
                            maxSize = 1;
                        }
                        for (int i = 2; i <= maxSize; ++i) {
                            ArrayList<Goods> goodsList;
                            block24: {
                                goodsList = new ArrayList<Goods>();
                                Object page1 = null;
                                try {
                                    String nextPage = ((Selectable)html.$("a.pageBtn").nodes().get(1)).links().get();
                                    String paterUrl = "https://www.comix.com.cn/Product/ProductList" + nextPage;
                                    HttpResponse pageHttpResponse = HttpRequest.get((String)paterUrl).execute();
                                    if (pageHttpResponse.isOk()) {
                                        html = this.createHtml(pageHttpResponse.body());
                                        Thread.sleep(200L);
                                        log.info("\u5f53\u524d\u4e3a\u7b2c{}\u9875", (Object)i);
                                        if (null != html) {
                                            this.pageProcess(html, goodsList, executionNumber, categoryId, categoryName);
                                            this.processDataPipeline.processDataList(goodsLists, i, maxSize, keyword);
                                        }
                                        break block24;
                                    }
                                    throw new DcBusinessException(httpResponse.body());
                                }
                                catch (Exception e) {
                                    log.info("\u9f50\u5fc3\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
                                }
                            }
                            this.processDataPipeline.processDataList(goodsList, i, finalMaxSize, keyword);
                            log.info("\u9f50\u5fc3\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6709{}\u6761\u6570\u636e", (Object)goodsLists.size());
                        }
                        break block23;
                    }
                    throw new DcBusinessException(httpResponse.body());
                }
                catch (Exception e) {
                    log.info("\u9f50\u5fc3\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
                    throw new DcBusinessException(e.getMessage());
                }
            }
        }
    }

    public void pageProcess(Html html, List<Goods> goodsLists, String executionNumber, String categoryId, String categoryName) {
        List goodsList = html.$("ul.list-item.clearfix > li").nodes();
        goodsList.forEach(goods -> {
            String href = goods.$("a", "href").get();
            String title = goods.$("a > div.row.title > div.proListTit ").xpath("///allText()").get();
            title = title.replace("<em>", "").replace("</em>", "");
            String money = goods.$("a > div.row.price").xpath("///allText()").get();
            String img = goods.$("a img").xpath("///@src").get();
            String url = "https://www.comix.com.cn" + href;
            BigDecimal price = new BigDecimal(0);
            if (money != null) {
                String value = money.replace("\u00a5", "");
                price = new BigDecimal(value);
            }
            Goods article = new Goods();
            article.setPrefix(MallType.Comix.getCode());
            if (StringUtils.isNotBlank((CharSequence)href)) {
                String st = href.replace(".html", "");
                String sku = st.substring(1, st.length());
                article.setGoodsNo(sku);
                article.setSkuId(sku);
            }
            article.setTitle(title);
            article.setPrice(price);
            article.setPic(img);
            article.setUrl(url);
            article.setCategoryId(categoryId);
            article.setCategoryName(categoryName);
            article.setCreated(new Date());
            article.setExecutionNumber(executionNumber);
            goodsLists.add(article);
        });
    }

    public void pageProcess1(Html html, List<Goods> goodsLists, String executionNumber, String categoryId, String categoryName) {
        List nodes = html.$("div.goods-list_item").nodes();
        if (nodes.size() != 0 && nodes.size() > 0) {
            HashSet handles = new HashSet();
            boolean counter = false;
            for (Selectable node : nodes) {
                String title = node.$("div.mc-size12.mc-ellipsis2.mc-mt-10.mc-mb-20.goods-text").xpath("///allText()").get();
                String picurl = node.$("div>a>div.el-image>img").xpath("///@src").get();
                String price = node.$("div.mc-size20.red-text.mc-bold").xpath("///allText()").get();
                String href = node.$("div>a").xpath("///@href").get();
                String price1 = price.replaceAll("\uffe5", "").trim();
                Pattern pattern = Pattern.compile("[^0-9]+");
                Matcher matcher = pattern.matcher(href);
                String skuId = matcher.replaceAll("").trim();
                BigDecimal price2 = new BigDecimal("0");
                price2 = new BigDecimal(price1);
                Goods goods = new Goods();
                goods.setPrefix(MallType.Comix.getCode());
                goods.setTitle(title);
                goods.setGoodsNo(skuId);
                goods.setSkuId(skuId);
                goods.setUrl(href);
                goods.setPrice(price2);
                goods.setPic(picurl);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsLists.add(goods);
            }
            log.info("\u9f50\u5fc3\u5de5\u4e1a\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c1\u9875\u6210\u529f");
        }
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

