/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DezhiProcessor {
    private static final Logger log = LoggerFactory.getLogger(DezhiProcessor.class);
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        DezhiProcessor.isAccurate = isAccurate;
    }

    public static void processor(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        int page = 1;
        ArrayList<Goods> goodsL = new ArrayList<Goods>();
        String keyword = paramTo.getKeyword();
        try {
            int total = DezhiProcessor.processorPage(paramTo, processDataPipeline, goodsL, page, executionNumber);
            if (StringUtils.isNotEmpty((CharSequence)keyword) && total > 1) {
                total = 1;
            }
            for (int i = 1; i < total; ++i) {
                Thread.sleep(200L);
                DezhiProcessor.processorPage(paramTo, processDataPipeline, goodsL, ++page, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u5fb7\u81f4\u5546\u6210\u5206\u7c7b{}\u8bf7\u6c42\u5931\u8d25,\u5f53\u524d\u9875{}", new Object[]{paramTo.getCategoryId(), page, e});
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static int processorPage(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, List<Goods> goodsL, int page, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        int totalPage = 0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        try {
            String result;
            String ajaxUrl = "https://fapiao-s.3c2p.com/api/p/product/list?keyword=" + keyword + "&pageNum=" + page;
            HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)ajaxUrl).header("referer", ajaxUrl)).execute();
            if (httpResponse.isOk() && (result = httpResponse.body()) != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                if (object != null) {
                    totalPage = object.getJSONObject("data").getJSONObject("products").getIntValue("totalPage");
                    JSONArray list = object.getJSONObject("data").getJSONObject("products").getJSONArray("list");
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (int i = 0; i < list.size(); ++i) {
                            JSONObject item = list.getJSONObject(i);
                            String skuName = item.getString("productName");
                            String skuCode = item.getString("productId");
                            String goodsNo = item.getString("productSn");
                            String imageUrl = item.getString("productBigImage");
                            String price = item.getString("productMarketPrice");
                            String brandId = item.getString("brandId");
                            String brandName = item.getString("brandName");
                            String categoryId = item.getString("categoryId");
                            Goods goods = new Goods();
                            goods.setCategoryName(categoryName);
                            goods.setCategoryId(categoryId);
                            goods.setPrefix(MallType.Dezhi.getCode());
                            goods.setTitle(skuName);
                            goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                            goods.setGoodsNo(goodsNo);
                            goods.setSkuId(skuCode);
                            goods.setPic(imageUrl);
                            goods.setCreated(new Date());
                            goods.setBrandId(brandId);
                            goods.setBrandName(brandName);
                            goods.setUrl("https://vmall.3c2p.com/views/detail/detail.html?productId=" + skuCode);
                            goods.setSkuState("1");
                            goods.setExecutionNumber(executionNumber);
                            goodsList.add(goods);
                        }
                    } else {
                        log.info("\u5fb7\u81f4\u5546\u6210{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                    }
                } else {
                    log.info("\u5fb7\u81f4\u5546\u6210{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5fb7\u81f4\u5546\u6210\u722c\u53d6\u5546\u54c1\u5217\u8868\u5931\u8d25{}", (Object)url, (Object)e);
        }
        processDataPipeline.processDataList(goodsList, page, totalPage, keyword);
        goodsL.addAll(goodsList);
        paramTo.setGoods(goodsL);
        return totalPage;
    }
}

