/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Component
public class DlProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(DlProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 30;

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        try {
            int totalPage = 1;
            log.info("\u5f97\u529b\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
            for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                JSONObject jsonObject = JSONObject.parseObject((String)"{\"sortName\":\"\",\"originalPriceEnd\":\"\",\"specList\":[],\"locateWh\":{\"hasStock\":\"\",\"regionCode\":\"1002\",\"cityCode\":\"14\",\"provinceCode\":\"10\"},\"locateProtocol\":{\"customerId\":\"\",\"hasProtocol\":\"\"},\"labels\":[],\"nowPage\":1,\"brandNameList\":[],\"backCategoryUuidList\":[],\"brandUuidList\":[],\"pageShow\":50,\"sortType\":\"\",\"totalNum\":0,\"keyword\":\"\",\"originalPriceStart\":\"\",\"frontCategoryUuid\":\"070ecc05e8b940b98f89985d62955e76\"}");
                jsonObject.put("nowPage", (Object)currentPage);
                jsonObject.put("frontCategoryUuid", (Object)categoryId);
                if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                    jsonObject.put("keyword", (Object)keyword);
                }
                String targetUrl = "https://b2b.nbdeli.com/front/productlist/search";
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(5, 10));
                HttpResponse response = HttpRequest.post((String)targetUrl).body(jsonObject.toString(), "application/json").execute();
                log.info("jsonObject:" + jsonObject);
                log.info("\u5f97\u529b\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)response.getStatus());
                if (response.isOk()) {
                    JsonPathSelector totalNum;
                    String total;
                    JsonPathSelector jsonPathSelector = new JsonPathSelector("$.retData");
                    String rawText = response.body();
                    String retData = jsonPathSelector.select(rawText);
                    if (StringUtils.isEmpty((CharSequence)retData)) {
                        return;
                    }
                    if (StringUtils.isEmpty((CharSequence)keyword) && StringUtils.isNotEmpty((CharSequence)(total = (totalNum = new JsonPathSelector("$.totalNum")).select(retData)))) {
                        totalPage = Integer.parseInt(total) / 50 + 1;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)retData)) {
                        DlProcessorWithSelfDriver.parsePage(retData, goodsList, categoryId, categoryName, executionNumber);
                        if (CollectionUtils.isNotEmpty(goodsList)) {
                            processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                        }
                    }
                } else {
                    throw new DcBusinessException("\u5f97\u529b\u63a5\u53e3\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                }
                if (!StringUtils.isNotEmpty((CharSequence)keyword)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("DlProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static void parsePage(String retData, List<Goods> goodsList, String categoryId, String categoryName, String executionNumber) {
        try {
            JsonPathSelector jsonPathSelector3 = new JsonPathSelector("$.skuList");
            List skuList = jsonPathSelector3.selectList(retData);
            JsonPathSelector productNameSelector = new JsonPathSelector("$.productName");
            JsonPathSelector skuNoSelector = new JsonPathSelector("$.skuNo");
            JsonPathSelector salePriceSelector = new JsonPathSelector("$.salePrice");
            JsonPathSelector bigPicSelector = new JsonPathSelector("$.bigPic");
            for (String sku : skuList) {
                String title = productNameSelector.select(sku);
                title = title.replaceAll("<[^<]*>", "");
                String skuNo = skuNoSelector.select(sku);
                String priceStr = salePriceSelector.select(sku);
                String pic = "";
                try {
                    if (sku.contains("bigPic")) {
                        pic = bigPicSelector.select(sku);
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u56fe\u7247\u5730\u5740\u5931\u8d25", (Throwable)e);
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.DL.getCode());
                goods.setGoodsNo(skuNo);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setTitle(title);
                goods.setPrice(StringUtils.isNotEmpty((CharSequence)priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setSkuId(skuNo);
                goods.setUrl("https://b2b.nbdeli.com/pcweb/detail?sku=" + skuNo);
                goods.setPic("https://img.jslink.com/" + pic);
                goods.setCreated(new Date());
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
        }
        catch (Exception e) {
            log.info("DlProcessorWithSelfDriver parsePage() : select() is error", (Throwable)e);
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

