/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class EsgccProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(EsgccProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 100;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        EsgccProcessorWithSelfDriver.isAccurate = isAccurate;
    }

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService, SelfDriver selfDriver, String executionNumber) {
        block10: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            RemoteWebDriver driver = selfDriver.getDriver();
            RemoteWebDriver a = selfDriver.getDriver();
            try {
                driver.get(url);
                a.get(url);
                Thread.sleep(5000L);
                Html html = EsgccProcessorWithSelfDriver.createHtml(driver.getPageSource());
                Selectable selectable = html.$("ul.ivu-page>div");
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                if (!Objects.isNull(selectable)) {
                    String totalPageStr1 = selectable.xpath("///allText()").get();
                    if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                        String totalPageStr2 = totalPageStr1.split("\u5171")[1];
                        String totalPageStr3 = totalPageStr2.split("\u9875")[0];
                        int totalPage = Integer.parseInt(totalPageStr3);
                        log.info("\u56fd\u7f51\u7535\u5546\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                        if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                            totalPage = 1;
                        }
                        for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                            PageOperateUtil.pageRefresh(driver);
                            html = EsgccProcessorWithSelfDriver.createHtml(driver.getPageSource());
                            EsgccProcessorWithSelfDriver.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, driver, a, executionNumber, url);
                            int finalCurrentPage = currentPage;
                            String finalKeyword = keyword;
                            int finalTotalPage = totalPage;
                            processDataPipeline.processDataList(goodsList, finalCurrentPage, finalTotalPage, finalKeyword);
                            if (currentPage == totalPage) break block10;
                            try {
                                driver.findElement(By.className((String)"ivu-page-next")).click();
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                log.error("EsgccProcessorWithSelfDriver : next.sendKeys(Keys.ENTER); is error");
                                break block10;
                            }
                            goodsList.clear();
                        }
                        break block10;
                    }
                    int totalPage = 1;
                    log.info("\u56fd\u7f51\u7535\u5546\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                    if (isAccurate && totalPage > 1) {
                        totalPage = 1;
                    }
                    int currentPage = 1;
                    PageOperateUtil.pageRefresh(driver);
                    html = EsgccProcessorWithSelfDriver.createHtml(driver.getPageSource());
                    EsgccProcessorWithSelfDriver.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, driver, a, executionNumber, url);
                    int finalCurrentPage = currentPage;
                    String finalKeyword = keyword;
                    int finalTotalPage = totalPage;
                    processDataPipeline.processDataList(goodsList, finalCurrentPage, finalTotalPage, finalKeyword);
                    goodsList.clear();
                    break block10;
                }
                log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
            }
            catch (Exception e) {
                log.error("EsgccProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
                if (driver != null) {
                    driver.quit();
                }
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, RemoteWebDriver driver, RemoteWebDriver a, String executionNumber, String url) throws MalformedURLException, InterruptedException {
        List nodes = html.$("div.ivu-card.goods-comp.column-style.thumbnail-hide").nodes();
        if (nodes.size() != 0) {
            if (nodes.size() <= 0) throw new DcBusinessException("\u56fd\u7f51\u7535\u5546\u5546\u57ce\u5206\u9875\u89e3\u6790\u9875\u9762\u5931\u8d25");
            HashSet handles = new HashSet();
            int counter = 0;
            for (Selectable node : nodes) {
                String title = node.$("div.ivu-card.goods-comp.column-style.thumbnail-hide>div.ivu-card-body>div.p-content>div.p-text>div.p-name").xpath("///allText()").get();
                String price = node.$("div.ivu-card-body>div.p-content>div.p-price").xpath("///allText()").get();
                String picUrl = node.$("div.ivu-card-body>div.p-img>img.anim").xpath("///@src").get();
                String price1 = price.replaceAll(" ", "").split("\uffe5")[1];
                BigDecimal price2 = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)price1)) {
                    price2 = price1.matches("\\d+(\\.\\d+)?") ? new BigDecimal(price1) : new BigDecimal("0");
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.Esgcc.getCode());
                goods.setTitle(title);
                goods.setPrice(price2);
                goods.setPic(picUrl);
                try {
                    WebElement element = (WebElement)driver.findElements(By.className((String)"p-img")).get(counter);
                    driver.executeScript("arguments[0].click();", new Object[]{element});
                    ++counter;
                    Thread.sleep(3000L);
                    Set windowHandles = driver.getWindowHandles();
                    String currentWindowHandle = driver.getWindowHandle();
                    int size = windowHandles.size();
                    int i = size - 1;
                    String handle = windowHandles.toArray(new String[0])[i];
                    driver.switchTo().window(handle);
                    String currentUrl = driver.getCurrentUrl();
                    goods.setUrl(currentUrl);
                    String Url0 = currentUrl.replaceAll(" ", "").split("&")[1];
                    String Url1 = Url0.replaceAll(" ", "").split("=")[1];
                    goods.setGoodsNo(Url1);
                    driver.get(currentUrl);
                    PageOperateUtil.pageRefresh(driver);
                    Html html1 = EsgccProcessorWithSelfDriver.createHtml(driver.getPageSource());
                    Selectable selectable1 = html1.$("div.magnifier-bottom>div.goods-code>span");
                    String totalPageStr1 = selectable1.xpath("///allText()").get();
                    if (StringUtils.isBlank((CharSequence)totalPageStr1)) {
                        Thread.sleep(3000L);
                        log.info("\u56fd\u7f51\u7535\u5546\u83b7\u53d6skuId\u4e3a\u7a7a\u7b49\u5f853\u79d2:{}", (Object)url);
                        totalPageStr1 = selectable1.xpath("///allText()").get();
                    }
                    goods.setSkuId(totalPageStr1);
                    driver.close();
                    driver.switchTo().window(currentWindowHandle);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
            log.info("\u56fd\u7f51\u7535\u5546\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
            return;
        }
        log.info("\u56fd\u7f51\u7535\u5546\u5546\u57ce\u6ca1\u6709\u8be5\u5546\u54c1");
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

