/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class GbbProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(GbbProcessorWithSelfDriver.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;

    public void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, SelfDriver selfDriver, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        try {
            int total;
            double res;
            driver.get(url);
            String url2 = driver.getCurrentUrl();
            if (!url.equals(url2)) {
                driver.get(url);
            }
            TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(10, 15));
            if (driver.getCurrentUrl().contains("https://www.gongbangbang.com/defense/60001?type=61111&num=0")) {
                CalcuLateDistanceUtil.gbbDistance((WebDriver)driver);
            }
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            Html html = this.createHtml(driver.getPageSource());
            this.parsePage(html, goodsList, categoryId, categoryName, executionNumber);
            processDataPipeline.processDataList(goodsList, 1, 1, keyword);
            String totalStr = html.$("div.sort_rBox__GPO8t > span:nth-child(4) > b", "text").toString();
            int totalPage = 1;
            if (StringUtils.isNotEmpty((CharSequence)totalStr) && (totalPage = (int)Math.ceil(res = (double)(total = Integer.parseInt(totalStr)) / 20.0)) > 1) {
                log.info("\u5de5\u90a6\u90a6\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                    totalPage = 1;
                }
                for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                    goodsList.clear();
                    log.info("\u5de5\u90a6\u90a6\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762", (Object)currentPage);
                    if (currentPage != totalPage) {
                        WebElement next = driver.findElement(By.className((String)"ant-pagination-next"));
                        next.sendKeys(new CharSequence[]{Keys.ENTER});
                    }
                    Thread.sleep(200L);
                    html = this.createHtml(driver.getPageSource());
                    this.parsePage(html, goodsList, categoryId, categoryName, executionNumber);
                    if (!CollectionUtils.isNotEmpty(goodsList)) continue;
                    processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                }
            }
        }
        catch (Exception e) {
            driver.quit();
            log.error("GbbDriver : driver.get() is error", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void parsePage(Html html, List<Goods> goodsList, String categoryId, String categoryName, String executionNumber) {
        List nodes = html.$("div.skuCard_skuBox__1P6hS").nodes();
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String title = node.$("div.skuCard_details__DMP9Y.ell2 > p").xpath("///allText()").get();
                String href = null;
                String price = node.$("div.skuCard_priceBox__7nPM9 > div>span > b").xpath("///allText()").get();
                String sku_id = node.$("div.skuCard_skuNoBox__5p5DN > span:nth-child(1)", "text").get();
                String picUrl = node.$("div.skuCard_imgBox__ckIyX > img").xpath("///@src").get();
                BigDecimal price1 = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)price)) {
                    price1 = price.matches("\\d+(\\.\\d+)?") ? new BigDecimal(price) : new BigDecimal("0");
                }
                if (StringUtils.isNotBlank((CharSequence)sku_id)) {
                    href = "https://www.gongbangbang.com/item/" + sku_id;
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.Gbb.getCode());
                goods.setGoodsNo(sku_id);
                goods.setSkuId(sku_id);
                goods.setTitle(title);
                goods.setPrice(price1);
                goods.setUrl(href);
                goods.setPic(picUrl);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
        }
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

