/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GongpinProcessor {
    private static final Logger log = LoggerFactory.getLogger(GongpinProcessor.class);
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        GongpinProcessor.isAccurate = isAccurate;
    }

    public static void processor(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        int page = 1;
        ArrayList<Goods> goodsL = new ArrayList<Goods>();
        String keyword = paramTo.getKeyword();
        try {
            int total = GongpinProcessor.processorPage(paramTo, processDataPipeline, goodsL, page, executionNumber);
            if (StringUtils.isNotEmpty((CharSequence)keyword) && total > 1) {
                total = 1;
            }
            for (int i = 1; i < total; ++i) {
                Thread.sleep(200L);
                GongpinProcessor.processorPage(paramTo, processDataPipeline, goodsL, ++page, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u6613\u5de5\u54c1\u5546\u57ce\u5206\u7c7b{}\u8bf7\u6c42\u5931\u8d25,\u5f53\u524d\u9875{}", new Object[]{paramTo.getCategoryId(), page, e});
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static int processorPage(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, List<Goods> goodsL, int page, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        int totalPage = 0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        try {
            String result;
            String ajaxUrl = "https://www.gongpin.com/api/search/direct/pc/search";
            JSONObject jsonObjectPost = JSONObject.parseObject((String)"{\"keyword\":\"null\",\"page\":null,\"limit\":50,\"spotGoods\":0,\"searchType\":0,\"channel\":\"pc_shop\"}");
            jsonObjectPost.put("keyword", (Object)keyword);
            jsonObjectPost.put("page", (Object)page);
            HttpResponse httpResponse = ((HttpRequest)HttpRequest.post((String)ajaxUrl).body(String.valueOf(jsonObjectPost), "application/json").header("Referer", url)).execute();
            if (httpResponse.isOk() && (result = httpResponse.body()) != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                if (object != null) {
                    int total = object.getJSONObject("data").getIntValue("total");
                    totalPage = (int)Math.ceil((double)total / 50.0);
                    JSONArray list = object.getJSONObject("data").getJSONArray("list");
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        for (int i = 0; i < list.size(); ++i) {
                            JSONObject item = list.getJSONObject(i);
                            String skuName = item.getString("skuName");
                            String skuCode = item.getString("skuCode");
                            String imageUrl = item.getString("imageUrl");
                            String price = item.getString("price");
                            String brandName = item.getString("brandName");
                            String categoryId = item.getString("categoryCode");
                            String goodNo = item.getString("modelCode");
                            Goods goods = new Goods();
                            goods.setCategoryName(categoryName);
                            goods.setPrefix(MallType.Gongpin.getCode());
                            goods.setTitle(skuName);
                            goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                            goods.setGoodsNo(skuCode);
                            goods.setSkuId(skuCode);
                            goods.setPic(imageUrl);
                            goods.setCreated(new Date());
                            goods.setBrandName(brandName);
                            goods.setCategoryId(categoryId);
                            goods.setUrl("https://www.gongpin.com/product/" + skuCode);
                            goods.setSkuState("1");
                            goods.setExecutionNumber(executionNumber);
                            goodsList.add(goods);
                        }
                    } else {
                        log.info("\u6613\u5de5\u54c1\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                    }
                } else {
                    log.info("\u6613\u5de5\u54c1\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                }
            }
        }
        catch (Exception e) {
            log.error("\u6613\u5de5\u54c1\u5546\u57ce\u722c\u53d6\u5546\u54c1\u5217\u8868\u5931\u8d25{}", (Object)url, (Object)e);
        }
        processDataPipeline.processDataList(goodsList, page, totalPage, keyword);
        goodsL.addAll(goodsList);
        paramTo.setGoods(goodsL);
        return totalPage;
    }
}

