/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class GuangboProcessor {
    private static final Logger log = LoggerFactory.getLogger(GuangboProcessor.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber) {
        block9: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            try {
                HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
                if (httpResponse.isOk()) {
                    String result = httpResponse.body();
                    Html html = GuangboProcessor.createHtml(result);
                    Selectable selectable = html.$("#search_bar > div.goodsrows > span");
                    ArrayList<Goods> goodsList = new ArrayList<Goods>();
                    if (!Objects.isNull(selectable)) {
                        String totalPageStr1 = selectable.xpath("///allText()").get();
                        if (StringUtils.isNotEmpty((CharSequence)totalPageStr1) && !totalPageStr1.equals("0")) {
                            int totalPage = Integer.parseInt(totalPageStr1) / 20 + 1;
                            log.info("Guangbo\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                            this.pageProcess(html, goodsList, 1, totalPage, categoryId, categoryName, executionNumber, keyword);
                            if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                                totalPage = 1;
                            }
                            for (int currentPage = 2; currentPage <= totalPage; ++currentPage) {
                                String ajaxurl = url + "&&currentPage=" + currentPage;
                                httpResponse = ((HttpRequest)HttpRequest.get((String)ajaxurl).header("Referer", url)).execute();
                                if (!httpResponse.isOk()) continue;
                                html = GuangboProcessor.createHtml(httpResponse.body());
                                this.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                            }
                        } else {
                            log.error("\u65e0\u5546\u54c1 totalPageStr1 \u4e3a:{}", (Object)totalPageStr1);
                        }
                    } else {
                        log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
                    }
                    break block9;
                }
                throw new DcBusinessException(httpResponse.body());
            }
            catch (Exception e) {
                log.error("matemro\u722c\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    private void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        List nodes = html.$("div.smallgoods>ul").nodes();
        String skuIds = "";
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String title = node.$("li.goodsnames>a").xpath("///allText()").get();
                String href = node.$("li.goodsnames>a").xpath("///@href").get();
                String price = node.$("li.goodslook > strong").xpath("///allText()").get();
                String picUrl = node.$("li.goodsimgs > span > p > a > img").xpath("///@src").get();
                String[] split = href.split("_");
                String sku = split[split.length - 1].replace(".htm", "").trim();
                String priceStr = price.replace("\u5546\u57ce\u4ef7\uff1a\u00a5", "");
                Goods goods = new Goods();
                goods.setPrefix(MallType.Guangbo.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setTitle(title);
                goods.setPic(picUrl);
                goods.setUrl("https://btob.guangbo.net" + href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goods.setPrice(StringUtils.isNotEmpty((CharSequence)priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goodsList.add(goods);
            }
            log.info("guangbo\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
            this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
            goodsList.clear();
        } else {
            log.info("guangbo\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

