/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.exception.ChromeDriverException;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class JdPhoneProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdPhoneProcessorWithSelfDriver.class);
    private static SpiderService spiderService;
    private static boolean enable;
    private static String cookie;
    public static final int MAX_OUT_TIME = 60;

    @Value(value="${nicc-plugin.spider.jdcookie}")
    public void setCookie(String cookie) {
        JdPhoneProcessorWithSelfDriver.cookie = cookie;
    }

    @Autowired
    public void setSpiderService(SpiderService spiderService) {
        JdPhoneProcessorWithSelfDriver.spiderService = spiderService;
    }

    @Value(value="${aliyun.spider.enable}")
    public void setEnable(boolean enable) {
        JdPhoneProcessorWithSelfDriver.enable = enable;
    }

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, SelfDriver selfDriver) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        Random random = new Random();
        ArrayList<Goods> goods = new ArrayList<Goods>();
        try {
            driver.get(url);
            TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
            int totalPage = 100;
            for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                PageOperateUtil.downScrollTo(driver);
                if (currentPage == totalPage) break;
            }
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            Html html = JdPhoneProcessorWithSelfDriver.createHtml(driver.getPageSource());
            JdPhoneProcessorWithSelfDriver.pageProcess(html, goodsList, 100, totalPage, categoryId, categoryName, driver, url);
            if (CollectionUtils.isNotEmpty(goodsList)) {
                processDataPipeline.processDataList(goodsList, 100, totalPage, keyword);
                log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)100);
                goods.addAll(goodsList);
            }
            paramTo.setGoods(goods);
        }
        catch (Exception e) {
            log.info("JdProcessorWithSelfDriver : driver.get() is error");
            driver.quit();
            throw new ChromeDriverException(e.getMessage());
        }
    }

    private static void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, RemoteWebDriver driver, String url) {
        List nodes = html.$("div.search_prolist_item").nodes();
        if (nodes == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)nodes)) {
            for (Selectable node : nodes) {
                String sku = node.xpath("///@skuid").get();
                String href = "https://item.jd.com/" + sku + ".html";
                String title = node.$("#pro_info_above_" + sku + " > div").xpath("///allText()").get();
                String priceStr = node.$("#dp_J_" + sku + "").xpath("///@pri").get();
                String pic = node.$("div.search_prolist_cover> img").xpath("///@src").get();
                if (!StringUtils.isNotBlank((CharSequence)sku)) continue;
                Goods goods = new Goods();
                goods.setPrefix(MallType.JD.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setUrl(href);
                goods.setTitle(StringUtils.isNotBlank((CharSequence)title) ? title : "");
                goods.setPic(StringUtils.isNotBlank((CharSequence)pic) ? pic : null);
                goods.setPrice(StringUtils.isNotBlank((CharSequence)priceStr) && ProcessRegexUtil.processJdPrice(priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goodsList.add(goods);
            }
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

