/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class JdProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(JdProcessorWithSelfDriver.class);
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    @Autowired
    private CommodityInformationServiceFactory commodityInformationServiceFactory;

    public void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, SelfDriver selfDriver, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        RemoteWebDriver driver = selfDriver.getDriver();
        Random random = new Random();
        ArrayList<Goods> goods = new ArrayList<Goods>();
        try {
            driver.get(url);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            PageOperateUtil.pageRefresh(driver);
            String currentUrl = driver.getCurrentUrl();
            boolean num = true;
            if (StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://www.jd.com/?") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://passport.jd.com/") || StringUtils.contains((CharSequence)driver.getCurrentUrl(), (CharSequence)"https://cfe.m.jd.com")) {
                return;
            }
            Html html = this.createHtml(driver.getPageSource());
            if (html != null) {
                String totalPageStr = html.$("div#J_bottomPage span.p-skip em b").xpath("///allText()").get();
                if (StringUtils.isEmpty((CharSequence)totalPageStr)) {
                    totalPageStr = html.$("div#J_topPage span.fp-text i").xpath("///allText()").get();
                }
                if (StringUtils.isEmpty((CharSequence)totalPageStr)) {
                    return;
                }
                int totalPage = totalPageStr != null ? Integer.parseInt(totalPageStr) : 0;
                log.info("\u4eac\u4e1c\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                    totalPage = 1;
                }
                for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                    html = this.createHtml(driver.getPageSource());
                    try {
                        if (html == null) {
                            return;
                        }
                        ArrayList<Goods> goodsList = new ArrayList<Goods>();
                        this.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, driver, url, executionNumber);
                        if (CollectionUtils.isNotEmpty(goodsList)) {
                            processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                            log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
                            goods.addAll(goodsList);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5206\u9875\u89e3\u6790\uff1a{}\u9875\u9762\u5931\u8d25error{}", (Object)currentPage, (Object)e);
                    }
                    if (currentPage == totalPage) break;
                    currentUrl = driver.getCurrentUrl();
                    if (StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://cfe.m.jd.com") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://www.jd.com/?from") || StringUtils.contains((CharSequence)currentUrl, (CharSequence)"https://passport.jd.com/")) continue;
                    try {
                        WebElement next = driver.findElementByClassName("pn-next");
                        if (next == null) {
                            next = driver.findElementByClassName("fp-next");
                        }
                        next.sendKeys(new CharSequence[]{Keys.ENTER});
                        PageOperateUtil.pageRefresh(driver);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("JdProcessorWithSelfDriver : next.sendKeys(Keys.ENTER); is error");
                    }
                }
            }
            paramTo.setGoods(goods);
        }
        catch (Exception e) {
            log.info("JdProcessorWithSelfDriver : driver.get() is error");
            driver.quit();
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, RemoteWebDriver driver, String url, String executionNumber) {
        boolean refreshCount = false;
        List nodes = new ArrayList();
        if (currentPage == totalPage) {
            if (nodes.size() == 0) {
                PageOperateUtil.pageRefresh(driver);
                html = this.createHtml(driver.getPageSource());
                nodes = html.$("ul.gl-warp.clearfix > li").nodes();
            }
        } else {
            for (int num = 1; nodes.size() < 60 && num <= 3; ++num) {
                PageOperateUtil.pageRefresh(driver);
                html = this.createHtml(driver.getPageSource());
                nodes = html.$("ul.gl-warp.clearfix > li").nodes();
            }
        }
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (Selectable node : nodes) {
                String label3;
                String label2;
                String sku = node.$("li").xpath("///@data-sku").get();
                String href = "https://item.jd.com/" + sku + ".html";
                String title = node.$("li").$("div.p-name em").xpath("///allText()").get();
                String priceStr = node.$("li").$("div.p-price i").xpath("///allText()").get();
                String pic = "https:" + node.$("div.p-img > a > img").xpath("///@src").get();
                String supplier_name = node.$("div.gl-i-wrap > div.p-shop > span.J_im_icon > a").xpath("///allText()").get();
                ArrayList<String> label = new ArrayList<String>();
                String three = null;
                String one = null;
                String two = null;
                String label1 = node.$("div.gl-i-wrap > div.p-icons ").xpath("///allText()").get();
                if (!StringUtils.isEmpty((CharSequence)label1)) {
                    one = label1.replaceAll("\\s+", ",");
                    label.add(one);
                }
                if (!StringUtils.isEmpty((CharSequence)(label2 = node.$("div.gl-i-wrap > div.p-icons > img").xpath("///@data-tips").get()))) {
                    two = label2;
                    label.add(two);
                }
                if (!StringUtils.isEmpty((CharSequence)(label3 = node.$("li").$("div.gl-i-wrap > div.p-name.p-name-type-2 >span").xpath("///allText()").get()))) {
                    three = label3;
                    label.add(three);
                }
                if (StringUtils.isEmpty((CharSequence)supplier_name)) {
                    supplier_name = node.$("div.gl-i-wrap > div.p-shop > span.J_im_icon > a").xpath("///allText()").get();
                }
                if (StringUtils.isEmpty((CharSequence)sku)) {
                    sku = node.$("li div.gl-i-wrap").xpath("///@data-sku").get();
                }
                if (!StringUtils.isNotBlank((CharSequence)sku)) continue;
                Goods goods = new Goods();
                goods.setPrefix(MallType.JD.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setUrl(href);
                goods.setTitle(StringUtils.isNotBlank((CharSequence)title) ? title : "");
                goods.setPic(StringUtils.isNotBlank((CharSequence)pic) ? pic : null);
                goods.setPrice(StringUtils.isNotBlank((CharSequence)priceStr) && ProcessRegexUtil.processJdPrice(priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setSupplierName(supplier_name);
                goods.setExecutionNumber(executionNumber);
                goods.setLabel(((Object)label).toString());
                goodsList.add(goods);
            }
        }
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

