/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.KlpDescriptionProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Keys;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class KlpProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(KlpProcessor.class);
    private RemoteWebDriver driver;
    @Resource
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private KlpDescriptionProcessor klpDescriptionProcessor;
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;

    public void process(Page page) {
        Request request = page.getRequest();
        String keyword = (String)request.getExtra("keyword");
        String executionNumber = (String)request.getExtra("executionNumber");
        try {
            this.driver = DriverFactory.createDiffDriver(PageLoadStrategy.NORMAL);
            String paterUrl = page.getUrl().toString();
            ArrayList<Goods> goodsLists = new ArrayList<Goods>();
            this.driver.get(paterUrl);
            Page page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
            Html html = page0.getHtml();
            String totalPage = html.$("input#pagecount0", "value").toString();
            int maxSize = 1;
            if (totalPage != null) {
                maxSize = Integer.parseInt(totalPage);
            }
            int finalMaxSize = maxSize;
            log.info("\u79d1\u529b\u666e\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)maxSize);
            if (paterUrl.contains("list.colipu") && maxSize > 100) {
                paterUrl = paterUrl.replace(".html", "") + "-1-2-a-a.html";
                this.driver.get(paterUrl);
                page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                html = page0.getHtml();
            }
            this.pageProcess(page0, goodsLists, keyword, executionNumber);
            this.processDataPipeline.processDataList(goodsLists, 1, finalMaxSize, keyword);
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                return;
            }
            BigDecimal price = new BigDecimal("0");
            int i = 0;
            for (i = 2; i <= maxSize; ++i) {
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                try {
                    WebElement next = this.driver.findElementByXPath("//*[text()='\u4e0b\u4e00\u9875']");
                    next.sendKeys(new CharSequence[]{Keys.ENTER});
                }
                catch (Exception e) {
                    break;
                }
                Page page1 = page;
                try {
                    page1 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.info("\u79d1\u529b\u666e\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
                }
                log.info("\u5f53\u524d\u4e3a\u7b2c{}\u9875", (Object)i);
                this.pageProcess(page1, goodsList, keyword, executionNumber);
                this.processDataPipeline.processDataList(goodsList, i, finalMaxSize, keyword);
                log.info("\u79d1\u529b\u666e\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6709{}\u6761\u6570\u636e", (Object)goodsList.size());
                if (i == 200 && goodsList.size() > 0) {
                    price = ((Goods)goodsList.get(goodsList.size() - 1)).getPrice();
                    if (price.compareTo(BigDecimal.ZERO) == 0) {
                        price = ((Goods)goodsList.get(goodsList.size() - 2)).getPrice();
                    }
                    if (price.compareTo(BigDecimal.ZERO) == 0) {
                        price = ((Goods)goodsList.get(goodsList.size() - 3)).getPrice();
                    }
                }
                if (!paterUrl.contains("list.colipu") || maxSize <= 100 || i != 200) continue;
                String url200 = this.driver.getCurrentUrl();
                if (url200.contains("pagenostr")) {
                    String urlslp = url200.substring(0, url200.lastIndexOf("pagenostr"));
                    paterUrl = urlslp + "=1&sorttype=2&brandkey=0&attributekey=0&startpricestr=" + price + "&endpricestr=a";
                } else {
                    String str = "";
                    if (url200.contains("-200,")) {
                        str = url200.substring(0, url200.lastIndexOf("-200,"));
                    } else if (url200.contains("-200-")) {
                        str = url200.substring(0, url200.lastIndexOf("-200-"));
                    }
                    paterUrl = str + "-1-2-" + price.intValue() + "-a.html";
                }
                this.driver.get(paterUrl);
                Page pageNext = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
                Thread.sleep(200L);
                Html htmlNe = pageNext.getHtml();
                String tPage = htmlNe.$("input#pagecount0", "value").toString();
                goodsList.clear();
                this.pageProcess(pageNext, goodsList, keyword, executionNumber);
                this.processDataPipeline.processDataList(goodsList, 1, finalMaxSize, keyword);
                i = 2;
                maxSize = Integer.parseInt(tPage);
            }
        }
        catch (Exception e) {
            log.info("\u79d1\u529b\u666e\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
        finally {
            if (this.driver != null) {
                try {
                    this.driver.quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
    }

    public void pageProcess(Page page, List<Goods> goodsLists, String keyword, String executionNumber) {
        Html html = page.getHtml();
        List goodsList = html.$("div.product-list").nodes();
        goodsList.forEach(goods -> {
            String categoryId = null;
            if (StringUtils.isEmpty((CharSequence)keyword)) {
                String paterUrl = page.getUrl().toString();
                String[] strings = paterUrl.split("[/ : . \\- _ # %]");
                categoryId = strings[strings.length - 2];
            }
            String link = goods.$("a.productlist-img").$("a", "href").get();
            String name = goods.$("a.productlist-img").$("a", "title").get();
            String money = goods.$("p.productlist-price span b").xpath("///allText()").get();
            String img = goods.$("a.productlist-img img").xpath("///@src").get();
            StringBuilder url = new StringBuilder();
            BigDecimal price = new BigDecimal(0);
            if (!link.contains("https://www.colipu.com")) {
                url.append("https://list.colipu.com").append(link);
            } else {
                url = url.append(link);
            }
            if (money != null) {
                String value = money.replace("\u00a5", "");
                price = new BigDecimal(value);
            }
            Pattern pattern = Pattern.compile("[^0-9]");
            Matcher matcher = pattern.matcher(url.toString());
            String goodsNo = matcher.replaceAll("").trim();
            Goods article = new Goods();
            article.setPrefix(MallType.Klp.getCode());
            article.setGoodsNo(goodsNo);
            article.setSkuId(goodsNo);
            article.setTitle(name);
            article.setPrice(price);
            article.setPic(img);
            article.setUrl(url.toString());
            article.setCategoryId(categoryId);
            article.setCreated(new Date());
            article.setExecutionNumber(executionNumber);
            goodsLists.add(article);
        });
    }

    public Site getSite() {
        return Site.me();
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.klpDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

