/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class LFutureProcessor {
    private static final Logger log = LoggerFactory.getLogger(LFutureProcessor.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        try {
            HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
            if (httpResponse.isOk()) {
                String result = httpResponse.body();
                Html html = LFutureProcessor.createHtml(result);
                String totalPageStr = null;
                List nodes = html.$("div.good-datapaging").nodes();
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                    totalPageStr = StringUtils.substringBetween((String)String.valueOf(nodes), (String)"\u5171", (String)"\u9875");
                    if (StringUtils.isNotEmpty((CharSequence)totalPageStr)) {
                        int totalPage = Integer.parseInt(totalPageStr.trim());
                        log.info("\u9886\u5148\u672a\u6765\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                        if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                            totalPage = 1;
                        }
                        for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                            String rawText;
                            String ajaxurl = "https://www.66123123.com/Goods/GoodsSearch?keyword=" + keyword + "#pageindex=" + currentPage + "";
                            httpResponse = HttpRequest.get((String)ajaxurl).execute();
                            log.info("\u9886\u5148\u672a\u6765\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)httpResponse.getStatus());
                            if (!httpResponse.isOk() || !StringUtils.isNotEmpty((CharSequence)(rawText = httpResponse.body()))) continue;
                            this.parsePage(rawText, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                        }
                    } else {
                        log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", (Object)totalPageStr);
                    }
                } else {
                    log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
                }
            }
        }
        catch (Exception e) {
            log.error("DlProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void parsePage(String rawText, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        try {
            Html html = LFutureProcessor.createHtml(rawText);
            List nodes = html.$("div.goods.clearfloat.fl").nodes();
            if (!CollectionUtils.isEmpty((Collection)nodes)) {
                for (Selectable node : nodes) {
                    String price = node.$("div.goods-price>span").xpath("///allText()").get();
                    String title = node.$("div.goods-img>a").xpath("///@title").get();
                    String skuNo = node.$("button").xpath("///@data-goodsid").get();
                    String href = node.$("div.goods-name>a").xpath("///@href").get();
                    String pic = node.$("div.goods-img>a>img").xpath("///@src").get();
                    Goods goods = new Goods();
                    goods.setPrefix(MallType.Lxwl.getCode());
                    goods.setTitle(title);
                    goods.setGoodsNo(skuNo);
                    goods.setCategoryId(categoryId);
                    goods.setCategoryName(categoryName);
                    goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                    goods.setSkuId(skuNo);
                    goods.setUrl("https://www.66123123.com/" + href);
                    goods.setPic(pic);
                    goods.setCreated(new Date());
                    goods.setExecutionNumber(executionNumber);
                    goodsList.add(goods);
                }
                log.info("lxwl\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
            } else {
                log.info("lxwl\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
            }
            this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
            goodsList.clear();
        }
        catch (Exception e) {
            log.info("DlProcessorWithSelfDriver parsePage() : select() is error", (Throwable)e);
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

