/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class MatemroProcessor {
    private static final Logger log = LoggerFactory.getLogger(MatemroProcessor.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        try {
            HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
            if (httpResponse.isOk()) {
                String result = httpResponse.body();
                Html html = MatemroProcessor.createHtml(result);
                Selectable selectable = html.$("span.totalCount");
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                if (!Objects.isNull(selectable)) {
                    String totalPageStr1 = selectable.xpath("///allText()").get();
                    if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                        int totalPage = Integer.parseInt(totalPageStr1) / 50 + 1;
                        log.info("Matemro\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                        this.pageProcess(html, goodsList, 1, totalPage, categoryId, categoryName, executionNumber, keyword);
                        if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                            totalPage = 1;
                        }
                        for (int currentPage = 2; currentPage <= totalPage; ++currentPage) {
                            String ajaxurl = "https://www.matemro.com/web/search?keyword=" + keyword + "&page=" + currentPage;
                            httpResponse = ((HttpRequest)HttpRequest.get((String)ajaxurl).header("Referer", url)).execute();
                            if (!httpResponse.isOk()) continue;
                            html = MatemroProcessor.createHtml(httpResponse.body());
                            this.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                        }
                    } else {
                        log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", (Object)totalPageStr1);
                    }
                } else {
                    log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
                }
            }
        }
        catch (Exception e) {
            log.error("matemro\u722c\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        List nodes = html.$("ul.list_pic>li").nodes();
        String skuIds = "";
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String title = node.$("div.goods-content > div.goods-pic > a").xpath("///@title").get();
                String href = node.$("div.goods-content > div.goods-pic > a").xpath("///@href").get();
                String picUrl = node.$("div.goods-content > div.goods-pic > a > img").xpath("///@src").get();
                String[] split = href.split("/");
                String sku = split[split.length - 1].replace(".html", "").trim();
                Goods goods = new Goods();
                goods.setPrefix(MallType.Matemro.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setTitle(title);
                goods.setPic(picUrl);
                goods.setUrl(href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goods.setPrice(new BigDecimal("0"));
                skuIds = skuIds + sku + ",";
                goodsList.add(goods);
            }
            try {
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String priceUrl = "https://www.matemro.com/web//search/list/price?commonIds=" + skuIds;
            HttpResponse httpResponse = HttpRequest.get((String)priceUrl).execute();
            if (!httpResponse.isOk()) throw new DcBusinessException("\u4ef7\u683c\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            String result = httpResponse.body();
            if (result != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                if (!object.getString("code").equals("200")) throw new DcBusinessException("\u4ef7\u683c\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
                JSONArray list = JSONObject.parseArray((String)object.get((Object)"data").toString(), (Feature[])new Feature[0]);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (Map map : list) {
                        for (Goods goods : goodsList) {
                            if (!map.get("commonId").toString().contains(goods.getSkuId())) continue;
                            if (map.get("apiPrice") != null) {
                                goods.setPrice(new BigDecimal(map.get("apiPrice").toString()));
                                continue;
                            }
                            if (map.get("orgPrice") == null) continue;
                            goods.setPrice(new BigDecimal(map.get("orgPrice").toString()));
                        }
                    }
                }
            }
            log.info("Matemro\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
            this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
            goodsList.clear();
            return;
        }
        log.info("Matemro\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

