/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class MroqxProcessor {
    private static final Logger log = LoggerFactory.getLogger(MroqxProcessor.class);
    private RemoteWebDriver driver;
    @Resource
    private ProcessDataPipeline processDataPipeline;
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;

    public void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService, String executionNumber) {
        block9: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            try {
                HttpResponse httpResponse = HttpRequest.get((String)url).execute();
                if (httpResponse.isOk()) {
                    Html html = this.createHtml(httpResponse.body());
                    ArrayList<Goods> goodsLists = new ArrayList<Goods>();
                    this.pageProcess(html, goodsLists, executionNumber, categoryId, categoryName);
                    String totalPage = html.$("input#total", "value").toString();
                    int maxSize = 1;
                    if (totalPage == null) break block9;
                    int finalMaxSize = maxSize = Integer.parseInt(totalPage);
                    log.info("\u9f50\u5fc3\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)maxSize);
                    if (StringUtils.isNotEmpty((CharSequence)keyword) && maxSize > 1) {
                        maxSize = 1;
                    }
                    for (int i = 2; i <= maxSize; ++i) {
                        ArrayList<Goods> goodsList;
                        block10: {
                            goodsList = new ArrayList<Goods>();
                            Object page1 = null;
                            try {
                                String nextPage = ((Selectable)html.$("a.pageBtn").nodes().get(1)).links().get();
                                String paterUrl = "https://www.comix.com.cn/Product/ProductList" + nextPage;
                                HttpResponse pageHttpResponse = HttpRequest.get((String)paterUrl).execute();
                                if (pageHttpResponse.isOk()) {
                                    html = this.createHtml(pageHttpResponse.body());
                                    Thread.sleep(200L);
                                    log.info("\u5f53\u524d\u4e3a\u7b2c{}\u9875", (Object)i);
                                    if (null != html) {
                                        this.pageProcess(html, goodsList, executionNumber, categoryId, categoryName);
                                    }
                                    break block10;
                                }
                                throw new DcBusinessException(httpResponse.body());
                            }
                            catch (Exception e) {
                                log.info("\u9f50\u5fc3\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
                            }
                        }
                        processDataPipeline.processDataList(goodsList, i, finalMaxSize, keyword);
                        log.info("\u9f50\u5fc3\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6709{}\u6761\u6570\u636e", (Object)goodsLists.size());
                    }
                    break block9;
                }
                throw new DcBusinessException(httpResponse.body());
            }
            catch (Exception e) {
                log.info("\u9f50\u5fc3\u5546\u57ce\u83b7\u53d6\u9875\u9762\u5931\u8d25", (Throwable)e);
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    public void pageProcess(Html html, List<Goods> goodsLists, String executionNumber, String categoryId, String categoryName) {
        List goodsList = html.$("ul.list-item.clearfix > li").nodes();
        goodsList.forEach(goods -> {
            String href = goods.$("a", "href").get();
            String title = goods.$("a > div.row.title > div.proListTit ").xpath("///allText()").get();
            title = title.replace("<em>", "").replace("</em>", "");
            String money = goods.$("a > div.row.price").xpath("///allText()").get();
            String img = goods.$("a img").xpath("///@src").get();
            String url = "https://www.comix.com.cn" + href;
            BigDecimal price = new BigDecimal(0);
            if (money != null) {
                String value = money.replace("\u00a5", "");
                price = new BigDecimal(value);
            }
            Goods article = new Goods();
            article.setPrefix(MallType.Comix.getCode());
            if (StringUtils.isNotBlank((CharSequence)href)) {
                String st = href.replace(".html", "");
                String sku = st.substring(1, st.length());
                article.setGoodsNo(sku);
                article.setSkuId(sku);
            }
            article.setTitle(title);
            article.setPrice(price);
            article.setPic(img);
            article.setUrl(url);
            article.setCategoryId(categoryId);
            article.setCategoryName(categoryName);
            article.setCreated(new Date());
            article.setExecutionNumber(executionNumber);
            goodsLists.add(article);
        });
    }

    public Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

