/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class ObeiProcessorWithSelfDriver {
    private static final Logger log = LoggerFactory.getLogger(ObeiProcessorWithSelfDriver.class);
    public static final int MAX_OUT_TIME = 100;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        ObeiProcessorWithSelfDriver.isAccurate = isAccurate;
    }

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, ExecutorService executorService, SelfDriver selfDriver, String executionNumber) {
        block9: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            RemoteWebDriver driver = selfDriver.getDriver();
            String totalStr = null;
            try {
                driver.get(url);
                WebDriverWait wait = new WebDriverWait((WebDriver)driver, 20L);
                WebElement element1 = null;
                try {
                    int num = 1;
                    while (element1 == null && num <= 3) {
                        element1 = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.name((String)"resultSum")));
                        if (element1 == null) continue;
                        totalStr = element1.getText();
                    }
                }
                catch (Exception num) {
                    // empty catch block
                }
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                if (totalStr == null || Integer.parseInt(totalStr) <= 10) break block9;
                int total = 0;
                int totalPage = 0;
                total = Integer.parseInt(totalStr);
                totalPage = total % 10 > 0 ? total / 10 + 1 : total / 10;
                log.info("\u6b27\u8d1d\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                    totalPage = 1;
                }
                for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                    PageOperateUtil.pageRefresh(driver);
                    Html html = ObeiProcessorWithSelfDriver.createHtml(driver.getPageSource());
                    ObeiProcessorWithSelfDriver.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, selfDriver, executionNumber);
                    int finalCurrentPage = currentPage;
                    String finalKeyword = keyword;
                    int finalTotalPage = totalPage;
                    processDataPipeline.processDataList(goodsList, finalCurrentPage, finalTotalPage, finalKeyword);
                    if (currentPage == totalPage) break;
                    try {
                        WebElement element = driver.findElement(By.className((String)"layui-laypage-next"));
                        element.click();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        log.error("ObeiProcessorWithSelfDriver : next.sendKeys(Keys.ENTER); is error");
                        break;
                    }
                    goodsList.clear();
                }
            }
            catch (Exception e) {
                log.error("ObeiProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
                driver.quit();
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    private static void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, SelfDriver selfDriver, String executionNumber) {
        List nodes = html.$("body>div.x-public-container>div.x-public-warp>div.p-search-box>div.list.typeItem.typeList.mar-top-10>div.layui-form.layui-border-box.layui-table-view>div.layui-table-box>div.layui-table-body.layui-table-main>table.layui-table>tbody>tr").nodes();
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String title = node.$("div.hand>span:nth-child(2)").xpath("///allText()").get();
                String href = node.$("dl.list-dl>dd:nth-child(3)").xpath("///@title").get();
                String price = node.$("div.p-list-price").xpath("///@finalpricedisplay").get();
                String picUrl = node.$("div.goodsLeft.fl>div.goodsLeftImg.toProductDetail>img").xpath("///@src").get();
                BigDecimal price1 = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)price)) {
                    price1 = price.matches("\\d+(\\.\\d+)?") ? new BigDecimal(price) : new BigDecimal("0");
                }
                Goods goods = new Goods();
                goods.setGoodsNo(href);
                goods.setSkuId(href);
                if (StringUtils.isNotBlank((CharSequence)href) && !href.startsWith("http")) {
                    href = "https://uat.obei.com.cn/obei-web-ec/OP/product-details.html?commodityCode=" + href;
                }
                String sku = href;
                goods.setPrefix(MallType.Obei.getCode());
                goods.setTitle(title);
                goods.setPrice(price1);
                goods.setPic(picUrl);
                goods.setUrl(href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
        } else {
            throw new DcBusinessException("\u6b27\u8d1d\u5546\u57ce\u5206\u9875\u89e3\u6790\u9875\u9762\u5931\u8d25");
        }
        log.info("\u6b27\u8d1d\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

