/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class OfsProcessorDriver {
    private static final Logger log = LoggerFactory.getLogger(OfsProcessorDriver.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber) {
        block10: {
            String url = paramTo.getUrl();
            String categoryId = paramTo.getCategoryId();
            String categoryName = paramTo.getName();
            String keyword = paramTo.getKeyword();
            try {
                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
                HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
                if (httpResponse.isOk()) {
                    String result = httpResponse.body();
                    Html html = OfsProcessorDriver.createHtml(result);
                    Selectable selectable = html.$("span.page-total");
                    ArrayList<Goods> goodsList = new ArrayList<Goods>();
                    if (!Objects.isNull(selectable)) {
                        String totalPageStr1 = selectable.xpath("///allText()").get();
                        if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                            int totalPage = Integer.parseInt(totalPageStr1);
                            log.info("ofs\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                            if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                                totalPage = 1;
                            }
                            for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                                String ajaxurl = "https://www.ofs.cn/gallery-ajax_get_goods.html";
                                String resultStr = "cat_id=&virtual_cat_id=&scontent=n," + keyword + "&orderBy=&showtype=grid&page=" + currentPage;
                                httpResponse = ((HttpRequest)HttpRequest.post((String)ajaxurl).body(resultStr, "application/x-www-form-urlencoded").header("Referer", url)).execute();
                                if (httpResponse.isOk()) {
                                    html = OfsProcessorDriver.createHtml(httpResponse.body());
                                    this.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                                }
                                TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(2, 5));
                            }
                        } else {
                            log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", (Object)totalPageStr1);
                        }
                    } else {
                        log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
                    }
                    break block10;
                }
                throw new DcBusinessException(httpResponse.body());
            }
            catch (Exception e) {
                log.error("ofs\u722c\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    private void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        List nodes = html.$("div.gallery-grid > ul>li").nodes();
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String title = node.$("div.goods-info>h3>a").xpath("///allText()").get();
                String href = node.$("div.goods-info>h3>a").xpath("///@href").get();
                String price = node.$("div.goods-info > div:nth-child(2) > ins").xpath("///allText()").get();
                String picUrl = node.$("div.goods-pic > a > img").xpath("///@src").get();
                BigDecimal price1 = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)price)) {
                    price = ProcessRegexUtil.extractNumbers(price);
                    price1 = new BigDecimal(price);
                }
                if (StringUtils.isNotBlank((CharSequence)href) && !href.startsWith("http")) {
                    href = "https://www.ofs.cn" + href;
                }
                String[] split = href.split("-");
                String sku = split[split.length - 1].replace(".html", "").trim();
                Goods goods = new Goods();
                goods.setPrefix(MallType.Ofs.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                goods.setTitle(title);
                goods.setPrice(price1);
                goods.setPic(picUrl);
                goods.setUrl(href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
            log.info("ofs\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
        } else {
            log.info("ofs\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
        }
        this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
        goodsList.clear();
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

