/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class QstbgProcessor {
    private static final Logger log = LoggerFactory.getLogger(QstbgProcessor.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        try {
            String ajaxUrl = "https://www.qstbg.com/gd/search/index.do";
            HttpRequest request = ((HttpRequest)((HttpRequest)HttpRequest.post((String)ajaxUrl).header("Referer", ajaxUrl)).header("Content-Type", "application/x-www-form-urlencoded")).body("goods_name=" + URLEncoder.encode(keyword, "UTF-8"));
            HttpResponse httpResponse = request.execute();
            if (httpResponse.isOk()) {
                String result = httpResponse.body();
                Html html = QstbgProcessor.createHtml(result);
                Object totalPageStr = null;
                Selectable selectable = html.$("strong.f60");
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                if (!Objects.isNull(selectable)) {
                    String totalPageStr1 = selectable.xpath("///allText()").get();
                    if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                        int totalPage2 = Integer.parseInt(totalPageStr1);
                        int totalPage = (int)Math.ceil(totalPage2 / 20);
                        log.info("\u4f01\u4e8b\u901a\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                        if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                            totalPage = 1;
                        }
                        for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                            String ajaxurl = "https://www.qstbg.com/gd/search/index.do";
                            String resultStr = "category_id=&category_name=&brand_id=&goods_name=" + keyword + "&price_b_begin=&price_b_end=&sales_volumeStr=&priceStr=&scoreStr=&strIsFromPage=1&intPageId=" + currentPage + "&strOrderColName=&strOrderType=&intNumPerPage=20";
                            httpResponse = ((HttpRequest)HttpRequest.post((String)ajaxurl).body(resultStr, "application/x-www-form-urlencoded").header("Referer", url)).execute();
                            log.info("\u4f01\u4e8b\u901a\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)httpResponse.getStatus());
                            if (!httpResponse.isOk()) continue;
                            String rawText = httpResponse.body();
                            this.parsePage(rawText, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                        }
                    } else {
                        log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", totalPageStr);
                    }
                } else {
                    log.error("selectable \u7a7a\u6307\u9488\uff0cHTML\u6587\u6863\u4e3a\uff1a{}", (Object)html);
                }
            }
        }
        catch (Exception e) {
            log.error("DlProcessorWithSelfDriver : driver.get() is error", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void parsePage(String rawText, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        try {
            Html html = QstbgProcessor.createHtml(rawText);
            List nodes = html.$("div.Product_b>ul>li").nodes();
            if (!CollectionUtils.isEmpty((Collection)nodes)) {
                for (Selectable node : nodes) {
                    String price1 = node.$("strong.anred").xpath("///allText()").get();
                    String price = price1.replace("\uffe5", "").replace(",", "");
                    String title = node.$("div.cpxq>span").xpath("///@title").get();
                    String href = node.$("div.num-buy-1>a").xpath("///@href").get();
                    String skuNo = href.split("=")[1].split("&")[0];
                    String pic = node.$("a.seller_box>img").xpath("///@src").get();
                    Goods goods = new Goods();
                    goods.setPrefix(MallType.Qstbg.getCode());
                    goods.setTitle(title);
                    goods.setGoodsNo(skuNo);
                    goods.setCategoryId(categoryId);
                    goods.setCategoryName(categoryName);
                    goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                    goods.setSkuId(skuNo);
                    goods.setUrl("https://www.qstbg.com/gd/detail.do?goods_id=" + skuNo);
                    goods.setPic(pic);
                    goods.setCreated(new Date());
                    goods.setExecutionNumber(executionNumber);
                    goodsList.add(goods);
                }
                log.info("\u4f01\u4e8b\u901a\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
            } else {
                log.info("\u4f01\u4e8b\u901a\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
            }
            this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
            goodsList.clear();
        }
        catch (Exception e) {
            log.info("DlProcessorWithSelfDriver parsePage() : select() is error", (Throwable)e);
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

