/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.ChineseCharactersUtils;
import com.tydic.nicc.spider.config.util.HttpClientUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class Tima365ProcessorDriver {
    private static final Logger log = LoggerFactory.getLogger(Tima365ProcessorDriver.class);
    @Value(value="${nicc-plugin.spider.isAccurate}")
    private boolean isAccurate;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Autowired
    private HttpClientUtil httpClientUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CategoryPO paramTo, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String keyword = paramTo.getKeyword();
        String categoryName = paramTo.getName();
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        Html html = null;
        try {
            String encoder = URLEncoder.encode(keyword, "UTF-8");
            HttpResponse httpResponse = ((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).header("Host", "www.tima365.com")).execute();
            if (httpResponse.isOk()) {
                String result = httpResponse.body();
                html = Tima365ProcessorDriver.createHtml(result);
            } else {
                RemoteWebDriver driver = null;
                try {
                    driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
                    driver.get(url);
                    Thread.sleep(500L);
                    html = Tima365ProcessorDriver.createHtml(driver.getPageSource());
                }
                catch (Exception e) {
                    log.error("\u6d59\u6c5f\u5b8f\u4f1f\u722c\u53d6\u5931\u8d25", (Throwable)e);
                }
                finally {
                    try {
                        driver.quit();
                    }
                    catch (Exception e) {}
                }
            }
            if (html != null) {
                String totalPageStr1 = html.$("em").xpath("///allText()").get();
                if (StringUtils.isNotEmpty((CharSequence)totalPageStr1)) {
                    int totalPage = Integer.parseInt(totalPageStr1);
                    log.info("\u6d59\u6c5f\u5b8f\u4f1f\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
                    if (StringUtils.isNotEmpty((CharSequence)keyword) && totalPage > 1) {
                        totalPage = 1;
                    }
                    for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                        if (currentPage == 1) {
                            JSONObject object;
                            String firstUrl = "https://www.tima365.com/front/queryBottomAndRightAdSku?keyword=" + encoder;
                            String response = ((HttpRequest)HttpRequest.get((String)firstUrl).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute().body();
                            if (!StringUtils.isNotBlank((CharSequence)response) || !Objects.equals("\u6210\u529f", (object = JSONObject.parseObject((String)response)).get((Object)"msg"))) continue;
                            this.firstPageProcess(object, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                            continue;
                        }
                        String ajaxurl = "https://www.tima365.com/frontshow/productlist/ajaxProductList?goodsType=&keyword=" + encoder + "sortType=&attrValue=&sortBy=&nowPage=" + currentPage + "&pageShow=20&flag=fromCategory&startPrice=NaN&endPrice=NaN&cat=";
                        httpResponse = ((HttpRequest)HttpRequest.get((String)ajaxurl).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36")).execute();
                        log.info("\u6d59\u6c5f\u5b8f\u4f1f\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)httpResponse.getStatus());
                        if (!httpResponse.isOk()) continue;
                        html = Tima365ProcessorDriver.createHtml(httpResponse.body());
                        this.pageProcess(html, goodsList, currentPage, totalPage, categoryId, categoryName, executionNumber, keyword);
                    }
                } else {
                    log.error("totalPageStr1 \u7a7a\u6307\u9488 \uff0ctotalPageStr1 \u4e3a:{}", (Object)totalPageStr1);
                }
            } else {
                log.error("\u6570\u636e\u83b7\u53d6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u6d59\u6c5f\u5b8f\u4f1f\u722c\u53d6\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void pageProcess(Html html, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        List nodes = html.$("div.pd-list > ul>li").nodes();
        if (nodes.size() > 0) {
            for (Selectable node : nodes) {
                String href = node.$("div.pic>a").xpath("///@href").get();
                String picUrl = node.$("div.pic > a > img").xpath("///@src").get();
                String price = node.$("div.price").xpath("///allText()").get();
                String sku = node.$("strong").xpath("///@data-skuNo").get();
                String together = node.$("div.pic > a > img").xpath("///@alt").get();
                String[] parts = together.split(" ");
                String brandName = parts[0];
                String title = parts[parts.length - 1];
                Goods goods = new Goods();
                goods.setPrefix(MallType.Tima.getCode());
                goods.setBrandName(brandName);
                goods.setGoodsNo(sku);
                goods.setTitle(title);
                if (ChineseCharactersUtils.containsChinese(price)) {
                    goods.setPrice(new BigDecimal(0));
                } else {
                    goods.setPrice(Objects.isNull(price) ? new BigDecimal(price) : new BigDecimal(price));
                }
                goods.setSkuId(sku);
                goods.setPic("https://www.tima365.com" + picUrl);
                goods.setUrl("https://www.tima365.com" + href);
                goods.setCategoryId(categoryId);
                goods.setCategoryName(categoryName);
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
            log.info("\u6d59\u6c5f\u5b8f\u4f1f\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
        } else {
            log.info("\u6d59\u6c5f\u5b8f\u4f1f\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u5931\u8d25", (Object)currentPage);
        }
        this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
        goodsList.clear();
    }

    private void firstPageProcess(JSONObject object, List<Goods> goodsList, int currentPage, int totalPage, String categoryId, String categoryName, String executionNumber, String keyword) {
        try {
            JSONArray list;
            Map dataMap;
            if (Objects.nonNull(object) && Objects.nonNull(dataMap = (Map)object.get((Object)"data")) && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)String.valueOf(dataMap.get("rightAdSkuList")), (Feature[])new Feature[0])))) {
                for (Map map : list) {
                    String matterCode = String.valueOf(map.get("matterCode"));
                    String pricingModel = String.valueOf(map.get("pricingModel"));
                    String brandName = String.valueOf(map.get("brandName"));
                    String mainImageKey = String.valueOf(map.get("mainImageKey"));
                    String markPrice = String.valueOf(map.get("markPrice"));
                    String price = String.valueOf(map.get("price"));
                    String facePrice = String.valueOf(map.get("facePrice"));
                    String skuNo = String.valueOf(map.get("skuNo"));
                    String productName = String.valueOf(map.get("productName"));
                    Goods goods = new Goods();
                    String title = "";
                    Document document = Jsoup.parse((String)productName);
                    Elements strongTags = document.select("strong");
                    title = StringUtils.isNotBlank((CharSequence)productName) && strongTags.size() > 0 ? ((Element)strongTags.get(strongTags.size() - 1)).parent().text() : productName;
                    Document doc = Jsoup.parse((String)brandName);
                    Elements ele = doc.select("strong");
                    String brandNames = StringUtils.isNotBlank((CharSequence)brandName) && brandName.contains("strong") ? ((Element)ele.get(ele.size() - 1)).parent().text().replace(" ", "") : brandName;
                    goods.setTitle(StringUtils.isEmpty((CharSequence)title) ? strongTags.text() : title.replace(" ", ""));
                    goods.setPrefix(MallType.Tima.getCode());
                    goods.setGoodsNo(skuNo);
                    goods.setCategoryId(categoryId);
                    goods.setCategoryName(categoryName);
                    goods.setBrandName(brandNames);
                    goods.setPrice(StringUtils.isNotEmpty((CharSequence)price) && !price.equals("\u9762\u8bae") ? new BigDecimal(price) : new BigDecimal(0));
                    goods.setSkuId(skuNo);
                    goods.setPic(mainImageKey);
                    goods.setUrl("https://www.tima365.com/product/" + skuNo);
                    goods.setCreated(new Date());
                    goods.setExecutionNumber(executionNumber);
                    goodsList.add(goods);
                }
                log.info("\u6d59\u6c5f\u5b8f\u4f1f\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\u6210\u529f", (Object)currentPage);
                this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                goodsList.clear();
            }
        }
        catch (Exception e) {
            log.info("\u6d59\u6c5f\u5b8f\u4f1f\u63a5\u53e3\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

