/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.XfsDescriptionProcessor;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Component
public class XfsProcessor {
    private static final Logger log = LoggerFactory.getLogger(XfsProcessor.class);
    @Resource
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private XfsDescriptionProcessor xfsDescriptionProcessor;

    public void process(CategoryPO paramTo, String executionNumber) {
        block19: {
            String categoryId = null;
            String keyword = paramTo.getKeyword();
            String encoder = "";
            try {
                HttpResponse httpResponse;
                if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                    encoder = URLEncoder.encode(keyword, "UTF-8");
                }
                String paterUrl = paramTo.getUrl().toString();
                String[] stringUrls = paterUrl.split("[/ : . \\- _ # % & =]");
                if (!paterUrl.contains("searchPro")) {
                    categoryId = stringUrls[7];
                }
                if ((httpResponse = HttpRequest.get((String)paterUrl).execute()).isOk()) {
                    Html html = new Html(httpResponse.body());
                    String count = html.$("span#f_result_sum").xpath("///allText()").get();
                    double res = Double.parseDouble(count) / 20.0;
                    int totalPage = (int)Math.ceil(res);
                    log.info("{}\u5206\u7c7b\u4e0b\u6709{}\u9875", (Object)categoryId, (Object)totalPage);
                    JSONObject jsonObject = JSONObject.parseObject((String)"{\"member_id\":null,\"customer_id\":\"\",\"customer_code\":\"\",\"account_type\":null,\"warehouse_code\":null,\"token\":null,\"ip\":\"\",\"host_name\":\"\",\"device_platform\":\"pc\",\"version_code\":0,\"device_id\":\"\",\"channel\":\"\",\"network\":\"\",\"device_brand\":\"\",\"os_version\":\"\",\"platformName\":\"\",\"memberId\":null,\"customerId\":null,\"customerCode\":null,\"mainCustomerId\":0,\"joinActivity\":10,\"domainName\":\"www.xfs.com\",\"cityCode\":\"110100\",\"warehouseId\":\"1\",\"platformType\":2,\"brandId\":null,\"categoryId\":21006,\"categoryLevel\":3,\"queryString\":null,\"listBrandIds\":null,\"listCategoryId\":null,\"listCategoryLevel\":null,\"advanceOptions\":[],\"priceSort\":null,\"popularSort\":null,\"saleSort\":null,\"promotionFilter\":null,\"stockFilter\":0,\"productTagFilter\":null,\"priceStart\":\"\",\"priceEnd\":\"\",\"scoreSort\":null,\"productDistributeFilter\":null,\"activityPerson\":10,\"activityId\":null,\"imgList\":null,\"spuCodes\":null,\"subWarehouseId\":null,\"pageIndex\":2,\"pageSize\":20,\"aggregateFlag\":true,\"fromRequestId\":null,\"materielSkuCodeList\":null,\"priceProvinceCode\":null,\"saleAreaId\":null,\"showNotPoolProduct\":false,\"currentCategoryLevel\":null,\"companyId\":null,\"subCompanyId\":null,\"includeProductTypes\":null,\"agreeProductPoolRuleId\":null,\"skuLimit\":6,\"specialDomain\":false,\"searchAll\":null,\"skuSummary\":true,\"login_account\":null}");
                    if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                        totalPage = 1;
                    }
                    BigDecimal price = new BigDecimal(0);
                    boolean isCirculate = false;
                    for (int i = 1; i <= totalPage; ++i) {
                        log.info("\u6211\u662f\u5f53\u524d\u9875\u9762:{}", (Object)i);
                        jsonObject.put("pageIndex", (Object)i);
                        jsonObject.put("categoryId", (Object)categoryId);
                        jsonObject.put("priceSort", (Object)1);
                        if (isCirculate) {
                            jsonObject.put("priceStart", (Object)price.intValue());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                            jsonObject.put("queryString", (Object)encoder);
                        }
                        String url = "https://www.xfs.com/api/pc/search/searchMainQuery";
                        HttpResponse response = null;
                        try {
                            HttpRequest httpRequest = HttpRequest.post((String)url).body(jsonObject.toString(), "application/json");
                            response = httpRequest.execute();
                            log.info("\u54cd\u5e94\u72b6\u6001{}", (Object)response.getStatus());
                            if (response.isOk()) {
                                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                                String rawText = response.body();
                                this.parsePage(rawText, goodsList, categoryId, executionNumber);
                                if (i == 50 && goodsList.size() > 0) {
                                    price = ((Goods)goodsList.get(goodsList.size() - 1)).getPrice();
                                    if (price.compareTo(BigDecimal.ZERO) == 0) {
                                        price = goodsList.get(goodsList.size() - 2).getPrice();
                                    }
                                    if (price.compareTo(BigDecimal.ZERO) == 0) {
                                        price = goodsList.get(goodsList.size() - 3).getPrice();
                                    }
                                }
                                String finalKeyword = keyword;
                                this.processDataPipeline.processDataList(goodsList, i, totalPage, finalKeyword);
                                if (50 == totalPage && i == totalPage) {
                                    String raw;
                                    JsonPathSelector jsonPathSelector3;
                                    List spuList;
                                    jsonObject.put("priceStart", (Object)price.intValue());
                                    jsonObject.put("pageIndex", (Object)1);
                                    response = HttpRequest.post((String)url).body(jsonObject.toString(), "application/json").execute();
                                    if (response.isOk() && null != (spuList = (jsonPathSelector3 = new JsonPathSelector("$.data.spuList")).selectList(raw = response.body())) && !spuList.isEmpty()) {
                                        log.info("\u6dfb\u52a0\u4ef7\u683c\u533a\u95f4\uff1a{}\u540e\u67e5\u8be2\u5546\u54c1\u6570\u91cf\uff1a{}", (Object)price.intValue(), (Object)spuList.size());
                                        if (20 >= spuList.size()) {
                                            isCirculate = true;
                                            totalPage = 50;
                                            i = 0;
                                        } else {
                                            ArrayList goodsLists = new ArrayList();
                                            this.parsePage(raw, goodsLists, categoryId, executionNumber);
                                            finalKeyword = keyword;
                                            this.processDataPipeline.processDataList(goodsList, i, totalPage, finalKeyword);
                                        }
                                    }
                                }
                            }
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (Exception e) {
                            log.error("Xfsprocessor process() is error: {}", (Throwable)e);
                        }
                    }
                    break block19;
                }
                throw new DcBusinessException("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            }
            catch (Exception e) {
                throw new DcBusinessException(e.getMessage());
            }
        }
    }

    private void parsePage(String rawText, List goodsList, String categoryId, String executionNumber) {
        JsonPathSelector jsonPathSelector3 = new JsonPathSelector("$.data.spuList");
        List spuList = jsonPathSelector3.selectList(rawText);
        JsonPathSelector skuListSelector = new JsonPathSelector("$.skuList");
        JsonPathSelector spuNameSelector = new JsonPathSelector("$.skuName");
        JsonPathSelector spuCodeSelector = new JsonPathSelector("$.skuCode");
        JsonPathSelector priceSelector = new JsonPathSelector("$.salePrice");
        JsonPathSelector spuImgSelector = new JsonPathSelector("$.skuImg");
        for (String spuStr : spuList) {
            List skuList = skuListSelector.selectList(spuStr);
            for (String skuStr : skuList) {
                String title = null;
                String price = null;
                String sku = null;
                String img = null;
                String url = null;
                try {
                    title = spuNameSelector.select(skuStr);
                    sku = spuCodeSelector.select(skuStr);
                    price = priceSelector.select(skuStr);
                    if (skuStr.contains("skuImg")) {
                        img = spuImgSelector.select(skuStr);
                    }
                    url = "https://www.xfs.com/productsku/" + sku + ".html";
                }
                catch (Exception e) {
                    log.info("\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                }
                Goods goods = new Goods();
                goods.setPrefix(MallType.Xfs.getCode());
                goods.setGoodsNo(sku);
                goods.setSkuId(sku);
                if (title != null) {
                    title = title.replaceAll("<[^<]*>", "");
                }
                goods.setTitle(title);
                goods.setPrice(StringUtils.isNotBlank((CharSequence)price) ? new BigDecimal(price) : new BigDecimal(0));
                goods.setPic(img);
                goods.setUrl(url);
                goods.setCategoryId(categoryId);
                goods.setCreated(new Date());
                goods.setExecutionNumber(executionNumber);
                goodsList.add(goods);
            }
        }
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.xfsDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

