/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.selector.Html;

@Component
public class XhgjProcessor {
    private static final Logger log = LoggerFactory.getLogger(XhgjProcessor.class);
    public static final int MAX_OUT_TIME = 30;
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        XhgjProcessor.isAccurate = isAccurate;
    }

    public static void process(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        String url = paramTo.getUrl();
        String categoryId = paramTo.getCategoryId();
        String categoryName = paramTo.getName();
        String keyword = paramTo.getKeyword();
        String encoder = "";
        try {
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                encoder = URLEncoder.encode(keyword, "UTF-8");
            }
            int totalPage = 1;
            log.info("\u54b8\u4ea8\u5546\u57ce{}\uff1a{}\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", new Object[]{categoryName, categoryId, totalPage});
            for (int currentPage = 1; currentPage <= totalPage; ++currentPage) {
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                url = "https://www.xhgjmall.com/SearchProduct?keywords=" + encoder + "&brandid=&field=&sortName=&sortType=&maxPrice=&minPrice=&curpage=" + currentPage + "&pagesize=20";
                String referer = "https://www.xhgjmall.com/Search/searchProductResult.htm?keywords=" + encoder;
                HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("Referer", referer)).header("Content-Type", "application/json")).execute();
                log.info("\u54b8\u4ea8\u5546\u57ce\u5206\u9875\u89e3\u6790\u7b2c\uff1a{}\u9875\u9762\uff0c\u54cd\u5e94\u72b6\u6001{}", (Object)currentPage, (Object)response.getStatus());
                if (response.isOk()) {
                    String result = response.body();
                    if (StringUtils.isNotEmpty((CharSequence)result)) {
                        JSONObject object = JSONObject.parseObject((String)result);
                        String total = object.getString("goodscount");
                        if (StringUtils.isNotEmpty((CharSequence)total)) {
                            totalPage = Integer.parseInt(total) / 20 + 1;
                        }
                        XhgjProcessor.parsePage(object, goodsList, categoryId, categoryName, executionNumber);
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(goodsList)) {
                            processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
                        }
                    }
                } else {
                    throw new DcBusinessException("\u54b8\u4ea8\u5546\u57ce\u63a5\u53e3\u83b7\u53d6\u6570\u636e\u5931\u8d25");
                }
                if (!StringUtils.isNotEmpty((CharSequence)keyword) || totalPage <= 1) continue;
                totalPage = 1;
            }
        }
        catch (Exception e) {
            log.error("\u54b8\u4ea8\u5546\u57ce\u63a5\u53e3\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static void parsePage(JSONObject object, List<Goods> goodsList, String categoryId, String categoryName, String executionNumber) {
        try {
            JSONArray list;
            JSONArray jsonObject;
            if (object != null && (jsonObject = object.getJSONArray("productlist")) != null && CollectionUtils.isNotEmpty((Collection)(list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0])))) {
                for (Map map : list) {
                    String title = map.get("goodstitle").toString();
                    String skuNo = map.get("goodsid").toString();
                    String skuId = map.get("productcode").toString();
                    String priceStr = map.get("goodsprice").toString();
                    String url = "https://www.xhgjmall.com/Product/detail_" + skuNo + ".htm";
                    String pic = map.get("goodsimg").toString();
                    Goods goods = new Goods();
                    goods.setPrefix(MallType.Xhgj.getCode());
                    goods.setGoodsNo(skuNo);
                    goods.setCategoryId(categoryId);
                    goods.setCategoryName(categoryName);
                    goods.setTitle(title);
                    goods.setPrice(StringUtils.isNotEmpty((CharSequence)priceStr) ? new BigDecimal(priceStr) : new BigDecimal(0));
                    goods.setSkuId(skuId);
                    goods.setUrl(url);
                    goods.setPic(pic);
                    goods.setCreated(new Date());
                    goods.setExecutionNumber(executionNumber);
                    goodsList.add(goods);
                }
            }
        }
        catch (Exception e) {
            log.info("\u54b8\u4ea8\u5546\u57ce\u63a5\u53e3\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    public static Html createHtml(String rawText) {
        return new Html(rawText);
    }
}

