/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.XyDescriptionProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceJDUtil;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

@Component
public class XyProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(XyProcessor.class);
    private RemoteWebDriver driver;
    @Resource
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private XyDescriptionProcessor xyDescriptionProcessor;

    public void process(Page page) {
        Request request = page.getRequest();
        String keyword = (String)request.getExtra("keyword");
        String executionNumber = (String)request.getExtra("executionNumber");
        this.driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
        this.driver.manage().timeouts().pageLoadTimeout(20L, TimeUnit.SECONDS);
        try {
            Html html = page.getHtml();
            HashMap map = new HashMap();
            String paterUrl = page.getUrl().get();
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            this.driver.get(paterUrl);
            TimeUnit.SECONDS.sleep(1L);
            PageOperateUtil.pageRefresh(this.driver);
            int num = 0;
            while (this.driver.getCurrentUrl().contains("https://gofast.ehsy.com/")) {
                if (num > 5) {
                    throw new DcBusinessException("xy\u9a8c\u8bc1\u7801\u5931\u8d25");
                }
                CalcuLateDistanceJDUtil.ehsyDistance(this.driver);
                ++num;
            }
            List pages = html.$("span.fullPage").nodes();
            if (CollectionUtils.isEmpty((Collection)pages)) {
                log.info("\u897f\u57df\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)0);
                this.driver.quit();
                return;
            }
            String total = ((Selectable)pages.get(0)).get();
            int totalPage = Integer.parseInt(ProcessRegexUtil.extractNumbers(total));
            if (paterUrl.contains("category-") && totalPage > 100) {
                this.getPageInfo("1", paterUrl, num);
                this.handleData("?s=1&", paterUrl, 100, goodsList, keyword, executionNumber);
                goodsList.clear();
                log.info("\u8fdb\u5165\u5012\u5e8f");
                this.getPageInfo("2", paterUrl, num);
                this.handleData("?s=2&", paterUrl, 100, goodsList, keyword, executionNumber);
            } else {
                this.handleData("?", paterUrl, totalPage, goodsList, keyword, executionNumber);
            }
        }
        catch (Exception e) {
            throw new DcBusinessException(e.getMessage());
        }
        finally {
            if (this.driver != null) {
                try {
                    this.driver.quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
    }

    private void getPageInfo(String s, String paterUrl, int num) throws InterruptedException {
        paterUrl = paterUrl + "?s=" + s;
        this.driver.get(paterUrl);
        TimeUnit.SECONDS.sleep(1L);
        PageOperateUtil.pageRefresh(this.driver);
        num = 0;
        while (this.driver.getCurrentUrl().contains("https://gofast.ehsy.com/")) {
            if (num > 5) {
                throw new DcBusinessException("xy\u9a8c\u8bc1\u7801\u5931\u8d25");
            }
            CalcuLateDistanceJDUtil.ehsyDistance(this.driver);
            ++num;
        }
    }

    private void handleData(String flag, String paterUrl, int totalPage, List<Goods> goodsList, String keyword, String executionNumber) {
        Page page0 = PageOperateUtil.createPage(paterUrl, this.driver.getPageSource());
        this.pageProcess(page0, goodsList, keyword, executionNumber);
        int finalTotalPage = totalPage;
        this.processDataPipeline.processDataList(goodsList, 1, finalTotalPage, keyword);
        if (totalPage == 0) {
            totalPage = 1;
        }
        log.info("\u897f\u57df\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)totalPage);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            return;
        }
        int i = 0;
        i = 2;
        while (i <= totalPage) {
            ArrayList<Goods> goodsList2 = new ArrayList<Goods>();
            String url = paterUrl + flag + "p=" + i;
            this.driver.get(url);
            PageOperateUtil.pageRefresh(this.driver);
            Page page1 = PageOperateUtil.createPage(url, this.driver.getPageSource());
            log.info("\u5f53\u524d\u9875\u9762\u4e3a{}", (Object)i);
            this.pageProcess(page1, goodsList2, keyword, executionNumber);
            int finalI = i++;
            this.processDataPipeline.processDataList(goodsList2, finalI, finalTotalPage, keyword);
        }
    }

    private void pageProcess(Page page, List<Goods> goodsLists, String keyword, String executionNumber) {
        Html html = page.getHtml();
        List lists = html.$("div.product").nodes();
        lists.forEach(list -> {
            String goodsNo;
            String img = list.$("img").xpath("///@src").get();
            String url = list.$("a", "href").get();
            String name = list.$("a", "title").get();
            String money = list.$("span.yen").xpath("///allText()").get();
            BigDecimal price = new BigDecimal(0);
            if (money != null && !money.equals("\u8be2\u4ef7")) {
                String[] str = money.split(" ");
                price = new BigDecimal(str[1]);
            }
            String brandName = list.$("li.high-light").xpath("///allText()").get();
            String paterUrl = page.getUrl().toString();
            String categoryId = ProcessRegexUtil.extractNumbers(paterUrl);
            if (StringUtils.isEmpty((CharSequence)keyword) && categoryId == null) {
                log.info("\u897f\u57df\u5546\u57ce{}\u4e0b\u6ca1\u6709categoryId", (Object)paterUrl);
                categoryId = "0";
            }
            if ((goodsNo = ProcessRegexUtil.processXyGoodsNo(url)) == null) {
                log.info("\u897f\u57df\u5546\u57ce{}\u4e0b\u7684{}\u6ca1\u6709goodsNo", (Object)paterUrl, (Object)name);
                goodsNo = name;
            }
            Goods article = new Goods();
            article.setPrefix(MallType.XiYu.getCode());
            article.setGoodsNo(goodsNo);
            article.setSkuId(goodsNo);
            article.setTitle(name);
            article.setPrice(price);
            article.setPic(img);
            article.setUrl(url);
            article.setCategoryId(categoryId);
            article.setCreated(new Date());
            article.setBrandName(brandName);
            article.setExecutionNumber(executionNumber);
            goodsLists.add(article);
        });
    }

    public Site getSite() {
        return Site.me().addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36").addHeader("Upgrade-Insecure-Requests", "1").addHeader("Sec-Fetch-Mode", "navigate");
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.xyDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

