/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class YzhProcessor {
    private static final Logger log = LoggerFactory.getLogger(YzhProcessor.class);
    private static boolean isAccurate;

    @Value(value="${nicc-plugin.spider.isAccurate}")
    public void setIsAccurate(boolean isAccurate) {
        YzhProcessor.isAccurate = isAccurate;
    }

    public static void processor(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, String executionNumber) {
        int page = 1;
        ArrayList<Goods> goodsL = new ArrayList<Goods>();
        String keyword = paramTo.getKeyword();
        try {
            int total = YzhProcessor.processorPage(paramTo, processDataPipeline, goodsL, page, executionNumber);
            if (StringUtils.isNotEmpty((String)keyword) && total > 1) {
                total = 1;
            }
            if (total > 1) {
                for (int i = 1; i < total; ++i) {
                    Thread.sleep(200L);
                    YzhProcessor.processorPage(paramTo, processDataPipeline, goodsL, ++page, executionNumber);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e91\u4e2d\u9e64\u5546\u57ce\u5206\u7c7b{}\u8bf7\u6c42\u5931\u8d25,\u5f53\u524d\u9875{}", new Object[]{paramTo.getCategoryId(), page, e});
            throw new DcBusinessException(e.getMessage());
        }
    }

    private static int processorPage(CategoryPO paramTo, ProcessDataPipeline processDataPipeline, List<Goods> goodsL, int currentPage, String executionNumber) {
        String keyword = paramTo.getKeyword();
        String url = paramTo.getUrl();
        int totalPage = 0;
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        try {
            String result;
            String ajaxurl = " https://gateway.haoxiny.com/portal/mall/goods/getGoodsPage?currentPage=" + currentPage + "&pageSize=50&goodsName=" + keyword + "&categoryCode=&onlyInStock=true";
            HttpResponse httpResponse = ((HttpRequest)((HttpRequest)HttpRequest.get((String)ajaxurl).header("referer", url)).header("Website-Path", "yzhs62")).execute();
            if (httpResponse.isOk() && (result = httpResponse.body()) != null) {
                JSONObject object = JSONObject.parseObject((String)result);
                JSONObject data = object.getJSONObject("data");
                JSONObject page = data.getJSONObject("page");
                totalPage = page.getInteger("totalPage");
                int totalCount = page.getInteger("totalRow");
                if (totalCount > 0) {
                    JSONArray jsonObject = data.getJSONArray("records");
                    if (jsonObject != null) {
                        JSONArray list = JSONObject.parseArray((String)jsonObject.toString(), (Feature[])new Feature[0]);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            for (Map map : list) {
                                Goods goods = new Goods();
                                String goodsCode = String.valueOf(map.get("goodsCode"));
                                String skuCode = String.valueOf(map.get("goodsSkuCode"));
                                String firstCategoryCode = String.valueOf(map.get("firstCategoryCode"));
                                String secondCategoryCode = String.valueOf(map.get("secondCategoryCode"));
                                String lastCategoryCode = String.valueOf(map.get("lastCategoryCode"));
                                String name = String.valueOf(map.get("goodsName"));
                                String name1 = name.replace("</span>", " ");
                                String name2 = name1.replace("<span style='color:red'>", "");
                                goods.setTitle(name2);
                                String price = String.valueOf(map.get("sellingPrice"));
                                goods.setGoodsNo(goodsCode);
                                goods.setPrefix(MallType.Yzh.getCode());
                                goods.setSkuId(skuCode);
                                goods.setUrl("https://www.haoxiny.com/goodDetail/goodDetail?goodsCode=" + goodsCode + "goodsSkuCode=" + skuCode + "&firstCategoryCode=" + firstCategoryCode + "&secondCategoryCode=" + secondCategoryCode + "lastCategoryCode=" + lastCategoryCode + "&mallPath=yzhs62");
                                goods.setPic(String.valueOf(map.get("imgUrl")));
                                goods.setPrice(StringUtils.isNotEmpty((String)price) ? new BigDecimal(price) : new BigDecimal(0));
                                goods.setSkuState("1");
                                goods.setExecutionNumber(executionNumber);
                                goods.setCreated(new Date());
                                goodsList.add(goods);
                            }
                            log.info("\u5f53\u524d\u603b\u5171{}\u9875,\u5f53\u524d\u7b2c{}\u9875", (Object)totalPage, (Object)page);
                        } else {
                            log.info("\u4e91\u4e2d\u9e64\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                        }
                    } else {
                        log.info("\u4e91\u4e2d\u9e64\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                    }
                } else {
                    log.info("\u4e91\u4e2d\u9e64\u5546\u57ce{}\u4e0b\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7684\u5546\u54c1", (Object)url);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e91\u4e2d\u9e64\u5546\u57ce\u722c\u53d6\u5546\u54c1\u5217\u8868\u5931\u8d25{}", (Object)url, (Object)e);
        }
        processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
        goodsL.addAll(goodsList);
        paramTo.setGoods(goodsL);
        return totalPage;
    }

    private static BigDecimal processPrice(String goodsCode, String firstCategoryCode, String secondCategoryCode, String lastCategoryCode) {
        JSONObject object;
        String result;
        if (StringUtils.isEmpty((String)goodsCode)) {
            goodsCode = "null";
        }
        BigDecimal price = new BigDecimal(0);
        String url = "https://www.haoxiny.com/commodityCenter/commodityCenter";
        HttpResponse httpResponse = ((HttpRequest)HttpRequest.get((String)url).header("referer", url)).execute();
        if (httpResponse.isOk() && (result = httpResponse.body()) != null && (object = JSONObject.parseObject((String)result)).get((Object)"success").toString().equals("true")) {
            JSONObject object1 = object.getJSONObject("result");
            price = new BigDecimal(object1.get((Object)"goodsPrice").toString());
        }
        return price;
    }
}

