/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.compoent.processor.goods;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.ZkhDescriptionProcessor;
import com.tydic.nicc.spider.config.util.CalcuLateDistanceUtil;
import com.tydic.nicc.spider.config.util.PageOperateUtil;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Html;

@Component
public class ZkhProcessor {
    private static final Logger log = LoggerFactory.getLogger(ZkhProcessor.class);
    @Resource
    private ZkhDescriptionProcessor zkhDescriptionProcessor;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    private ProcessDataPipeline processDataPipeline;

    public void process(CategoryPO paramTo, String executionNumber, RemoteWebDriver driver) {
        HashMap map = new HashMap();
        String paterUrl = paramTo.getUrl().toString();
        String keyword = paramTo.getKeyword();
        try {
            driver.get(paterUrl);
            driver.manage().timeouts().implicitlyWait(5L, TimeUnit.SECONDS);
            PageOperateUtil.pageRefreshOder(driver);
            Page page0 = PageOperateUtil.createPage(paterUrl, driver.getPageSource());
            Html html = page0.getHtml();
            String maxSize = html.css("b.pagination-page-total").xpath("///allText()").get();
            int totalPage = 1;
            if (maxSize != null) {
                totalPage = Integer.parseInt(maxSize);
            }
            log.info("\u9707\u5764\u884c\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u6700\u5927\u9875\u6570\u4e3a:{}", (Object)totalPage);
            List items = html.$("div.goods-item-wrap-new").nodes();
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                this.pageProcess(page0, 1, totalPage, keyword, executionNumber);
            } else {
                log.info("\u722c\u53d6\u9707\u5764\u884c\u5546\u57ce\u65f6IP\u88ab\u5c01");
                int num = 0;
                while (driver.getCurrentUrl().contains("https://www.zkh.com/robotVerify.html")) {
                    if (num > 5) {
                        throw new DcBusinessException("\u9a8c\u8bc1\u9a8c\u8bc1\u7801\u5931\u8d25");
                    }
                    CalcuLateDistanceUtil.calcuLateDistance(driver);
                    ++num;
                }
                PageOperateUtil.pageRefreshOder(driver);
                page0 = PageOperateUtil.createPage(paterUrl, driver.getPageSource());
                html = page0.getHtml();
                items = html.$("div.goods-item-wrap-new").nodes();
                if (CollectionUtils.isEmpty((Collection)items)) {
                    throw new DcBusinessException("zkh\u5546\u57ceip\u88ab\u5c01");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                return;
            }
            String num = html.$("#screenFilter > span > b").xpath("///allText()").get();
            int currentPage = 2;
            for (int i = 2; i <= totalPage; ++i) {
                try {
                    WebElement next = driver.findElementByClassName("nextbtn");
                    next.click();
                }
                catch (Exception e) {
                    break;
                }
                PageOperateUtil.pageRefreshOder(driver);
                Page page1 = PageOperateUtil.createPage(paterUrl, driver.getPageSource());
                log.info("\u5f53\u524d\u9875\u4e3a{}\u9875", (Object)currentPage);
                this.pageProcess(page1, currentPage, totalPage, keyword, executionNumber);
                ++currentPage;
            }
        }
        catch (Exception e) {
            log.error("zkh\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    private void pageProcess(Page page, int currentPage, int totalPage, String keyword, String executionNumber) {
        String paterUrl = page.getUrl().toString();
        Html html = page.getHtml();
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(paterUrl);
        String categoryId = matcher.replaceAll("").trim();
        List divs = html.$("div.goods-item-wrap-new").nodes();
        log.info("\u7b2c{}\u9875\u5904\u7406\u6570\u636e\u5f00\u59cb,\u6570\u636e\u6709{}\u6761", (Object)currentPage, (Object)divs.size());
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        if (divs != null && divs.size() > 0) {
            log.info("\u7b2c{}\u9875\u6570\u636e\u6b63\u5e38", (Object)currentPage);
            divs.forEach(item -> {
                String link = item.$("a", "href").get();
                String name = item.css("div.goods-name").xpath("///allText()").get();
                String imgPath = item.css("div.goods-img img").xpath("///@src").get();
                String integer = item.css("span.integer").xpath("///allText()").get();
                String decimal = item.css("span.decimal").xpath("///allText()").get();
                BigDecimal price = new BigDecimal(0);
                if (integer != null || decimal != null) {
                    StringBuilder money = new StringBuilder();
                    money.append(integer).append(decimal);
                    price = new BigDecimal(money.toString());
                }
                Pattern pattern1 = Pattern.compile("(?<item>/item/)(?<goodsNo>\\w*)(?<html>.html)");
                String goodsNo = null;
                Matcher matcher1 = pattern1.matcher(link);
                if (matcher1.find()) {
                    goodsNo = matcher1.group("goodsNo");
                } else {
                    log.info("\u9707\u5764\u884c\u5546\u57ce\u6b64\u5206\u7c7b\u4e0b\u83b7\u53d6categoryId\u5931\u8d25");
                }
                StringBuilder url = new StringBuilder();
                url.append("https://www.zkh.com/item/").append(goodsNo).append(".html");
                Goods article = new Goods();
                article.setPrefix(MallType.ZKH.getCode());
                article.setGoodsNo(goodsNo);
                article.setSkuId(goodsNo);
                article.setTitle(name);
                article.setPrice(price);
                article.setPic(imgPath);
                article.setUrl(url.toString());
                if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                    article.setCategoryId("0");
                } else {
                    article.setCategoryId(categoryId);
                }
                article.setCreated(new Date());
                article.setExecutionNumber(executionNumber);
                goodsList.add(article);
            });
        }
        this.processDataPipeline.processDataList(goodsList, currentPage, totalPage, keyword);
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, List<Goods> goodsLists, String keyword) {
        goodsLists.forEach(goods -> {
            hashMap.put("goods", goods);
            hashMap.put("keyword", keyword);
            request.setUrl(goods.getUrl());
            request.setExtras((Map)hashMap);
            Spider.create((PageProcessor)this.zkhDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        });
    }
}

