/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.aspect;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.spider.config.aspect.SpiderLog;
import com.tydic.nicc.spider.mapper.SpiderPushUrlMapper;
import com.tydic.nicc.spider.mapper.SpiderSyncLogMapper;
import com.tydic.nicc.spider.mapper.po.SpiderPushUrl;
import com.tydic.nicc.spider.mapper.po.SpiderSyncLogPO;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SpiderLogAspect {
    private static Logger logger = LoggerFactory.getLogger(SpiderLogAspect.class);
    @Value(value="${nicc-plugin.spider.taskcallBackUrl}")
    private String taskcallBackUrl;
    @Value(value="${isSingleExecute}")
    private boolean isSingleExecute;
    @Autowired
    private SpiderSyncLogMapper syncLogMapper;
    @Autowired
    private SpiderPushUrlMapper spiderPushUrlMapper;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    @Pointcut(value="@annotation(com.tydic.nicc.spider.config.aspect.SpiderLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public void handleAround(ProceedingJoinPoint joinPoint) throws Throwable {
        logger.info("\u8bb0\u5f55\u65e5\u5fd7");
        Object[] args = joinPoint.getArgs();
        Object result = joinPoint.proceed();
        HashMap<String, String> param = new HashMap<String, String>();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        SpiderLog log = methodSignature.getMethod().getAnnotation(SpiderLog.class);
        SpiderSyncLogPO syncLogPO = SpiderSyncLogPO.builder().spiderType(log.spiderType()).createTime(new Date()).build();
        if (args != null) {
            Object object = args[0];
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)object);
            String sign = jsonObject.getString("mall");
            if (StringUtils.isEmpty((CharSequence)sign)) {
                sign = jsonObject.getString("prefix");
            }
            String executionNumber = jsonObject.getString("executionNumber");
            String goodsNo = jsonObject.getString("goodsNo");
            syncLogPO.setSign(sign);
            syncLogPO.setReqBody(jsonObject.toString());
            syncLogPO.setExecutionNumber(executionNumber);
            syncLogPO.setGoodsNo(goodsNo);
            param.put("taskId", executionNumber);
            param.put("executionNumber", executionNumber);
        }
        if (Objects.nonNull(result)) {
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)result);
            String rspCode = jsonObject.getString("rspCode");
            if (StringUtils.isNotEmpty((CharSequence)rspCode) && rspCode.equals("0000")) {
                syncLogPO.setSpiderState(Integer.valueOf(1));
                param.put("status", "1");
            } else {
                syncLogPO.setSpiderState(Integer.valueOf(0));
                param.put("status", "0");
            }
            syncLogPO.setErrorMsg(result.toString());
        }
        this.syncLogMapper.insertSelective(syncLogPO);
        if (this.isSingleExecute) {
            try {
                String source;
                SpiderPushUrl pushUrl;
                if (param.get("executionNumber") != null && (pushUrl = this.spiderPushUrlMapper.selectBySource(source = param.get("executionNumber").toString().split("-")[0])) != null) {
                    this.taskcallBackUrl = pushUrl.getTaskcallBackUrl();
                }
                String resultStr = JSON.toJSONString(param);
                HttpResponse httpResponse = HttpRequest.post((String)this.taskcallBackUrl).body(resultStr, "application/json").execute();
                logger.info(httpResponse.body());
            }
            catch (Exception e) {
                logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

