/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.configuration;

import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="spring.redis")
public class RedissonConfig {
    private String host;
    private String addresses;
    private String password;
    private String port;
    private int timeout = 3000;
    private int connectionPoolSize = 64;
    private int connectionMinimumIdleSize = 10;
    private int pingConnectionInterval = 60000;
    private static String ADDRESS_PREFIX = "redis://";

    @Bean
    RedissonClient redissonSingle() {
        Config config = new Config();
        if (StringUtils.isEmpty((CharSequence)this.host)) {
            throw new RuntimeException("host is  empty");
        }
        SingleServerConfig serverConfig = ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(ADDRESS_PREFIX + this.host + ":" + this.port).setTimeout(this.timeout)).setPingConnectionInterval(this.pingConnectionInterval)).setConnectionPoolSize(this.connectionPoolSize).setConnectionMinimumIdleSize(this.connectionMinimumIdleSize);
        if (!StringUtils.isEmpty((CharSequence)this.password)) {
            serverConfig.setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }

    public String getHost() {
        return this.host;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int getConnectionMinimumIdleSize() {
        return this.connectionMinimumIdleSize;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setConnectionMinimumIdleSize(int connectionMinimumIdleSize) {
        this.connectionMinimumIdleSize = connectionMinimumIdleSize;
    }

    public void setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonConfig)) {
            return false;
        }
        RedissonConfig other = (RedissonConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
            return false;
        }
        if (this.getConnectionMinimumIdleSize() != other.getConnectionMinimumIdleSize()) {
            return false;
        }
        if (this.getPingConnectionInterval() != other.getPingConnectionInterval()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$addresses = this.getAddresses();
        String other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !this$addresses.equals(other$addresses)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        return !(this$port == null ? other$port != null : !this$port.equals(other$port));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedissonConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getConnectionPoolSize();
        result = result * 59 + this.getConnectionMinimumIdleSize();
        result = result * 59 + this.getPingConnectionInterval();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : $addresses.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        return result;
    }

    public String toString() {
        return "RedissonConfig(host=" + this.getHost() + ", addresses=" + this.getAddresses() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", connectionMinimumIdleSize=" + this.getConnectionMinimumIdleSize() + ", pingConnectionInterval=" + this.getPingConnectionInterval() + ")";
    }
}

