/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.factory;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.config.aspect.SpiderLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.springframework.stereotype.Component;

@Component
public class CommodityInformationServiceFactory {
    @Resource
    private Map<String, CommodityInformationService> map = new ConcurrentHashMap<String, CommodityInformationService>();

    public void addCategory(String mall) {
        this.map.get(mall).addCategory();
    }

    public void climbCommodityInformation(SpiderBO spiderBo) {
        this.map.get(spiderBo.getMall()).climbCommodityInformation(spiderBo.getCategoryId());
    }

    @SpiderLog(spiderType="1")
    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        return this.map.get(parameter.getMall()).climbCommodityTabulate(parameter);
    }

    @SpiderLog(spiderType="1_2")
    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBo) {
        return this.map.get(spiderBo.getMall()).climbProductDetailsWithCategoryId(spiderBo);
    }

    public String climbProductDetails(String mall) {
        return this.map.get(mall).climbProductDetails();
    }

    public void climbProductInfoByCache(String mall) {
        this.map.get(mall).climbProductInfoByCache();
    }

    public void climbProductTabByCache(String mall) {
        this.map.get(mall).climbProductTabByCache();
    }

    @SpiderLog(spiderType="3")
    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        return this.map.get(goodsBO.getPrefix()).climbProductDetailsByGoodsNo(goodsBO);
    }

    @SpiderLog(spiderType="2")
    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        return this.map.get(spiderBO.getMall()).climbProductDetailsByKeyword(spiderBO);
    }

    public RemoteWebDriver loginCookie(String mall, RemoteWebDriver driver) {
        return this.map.get(mall).loginCookie(driver);
    }

    @SpiderLog(spiderType="3")
    public Rsp climbProductDetailsByUrl(SpiderBO spiderBO) {
        return this.map.get(spiderBO.getMall()).climbProductDetailsByUrl(spiderBO);
    }
}

