/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.factory;

import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.po.ProxyConfig;
import com.tydic.nicc.spider.vo.ProxyConfigVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class HttpProxyFactory {
    public static final ConcurrentHashMap<String, List<ProxyConfigVO>> proxys = new ConcurrentHashMap();

    public static void init(List<ProxyConfig> proxyConfigs) {
        MallType[] mallTypes;
        List proxyConfigVOs = proxyConfigs.stream().map(ProxyConfigVO::new).collect(Collectors.toList());
        for (MallType mallType : mallTypes = MallType.values()) {
            proxys.put(mallType.getCode(), new ArrayList(proxyConfigVOs));
        }
    }

    public static List<ProxyConfigVO> get(String name) {
        return proxys.get(name);
    }

    public static int size(String name) {
        return HttpProxyFactory.get(name).size();
    }

    public static ProxyConfigVO getProxyConfigRandom(String name) {
        List<ProxyConfigVO> proxyConfigVOs = HttpProxyFactory.get(name);
        ProxyConfigVO res = null;
        if (CollectionUtils.isNotEmpty(proxyConfigVOs)) {
            ArrayList<ProxyConfigVO> randomProxyConfigVOs = new ArrayList<ProxyConfigVO>();
            for (ProxyConfigVO next : proxyConfigVOs) {
                if (next.getStatus().get()) continue;
                randomProxyConfigVOs.add(next);
            }
            res = (ProxyConfigVO)randomProxyConfigVOs.get(new Random().nextInt(randomProxyConfigVOs.size()));
        }
        return res;
    }

    public static boolean remove(String name, String proxy) {
        boolean ret = false;
        List<ProxyConfigVO> ProxyConfigVOs = HttpProxyFactory.get(name);
        if (CollectionUtils.isNotEmpty(ProxyConfigVOs)) {
            for (ProxyConfigVO proxyConfigVO : ProxyConfigVOs) {
                if (proxyConfigVO.getStatusValue() || !Objects.equals(proxyConfigVO.getProxyConfig().getProxy(), proxy)) continue;
                ret = ProxyConfigVOs.remove(proxyConfigVO);
                break;
            }
        }
        return ret;
    }

    public static void add(String name, ProxyConfig proxyConfig) {
        List<ProxyConfigVO> proxyConfigVOs = HttpProxyFactory.get(name);
        if (CollectionUtils.isNotEmpty(proxyConfigVOs)) {
            proxyConfigVOs.add(new ProxyConfigVO(proxyConfig));
        }
    }
}

