/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.listener;

import com.tydic.nicc.spider.config.factory.HttpProxyFactory;
import com.tydic.nicc.spider.config.thread.SpiderDetThreadMan;
import com.tydic.nicc.spider.config.thread.SpiderLiThreadMan;
import com.tydic.nicc.spider.mapper.ProxyConfigMapper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="nicc-plugin.chrome.proxy")
public class AppInitRunner
implements CommandLineRunner {
    private List<String> urls;
    @Value(value="${nicc-plugin.chrome.chromedriver-location}")
    private String chromedriverLocation;
    @Resource
    private ProxyConfigMapper proxyConfigMapper;
    @Resource
    private SpiderDetThreadMan spiderDetThreadMan;
    @Resource
    private SpiderLiThreadMan spiderLiThreadMan;
    private static final String STATUS = "1";

    public void run(String ... args) throws Exception {
        System.setProperty("webdriver.chrome.driver", this.chromedriverLocation);
        HttpProxyFactory.init(this.proxyConfigMapper.selectByStatus(STATUS));
        new Thread(this.spiderDetThreadMan).start();
        new Thread(this.spiderLiThreadMan).start();
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public String getChromedriverLocation() {
        return this.chromedriverLocation;
    }

    public ProxyConfigMapper getProxyConfigMapper() {
        return this.proxyConfigMapper;
    }

    public SpiderDetThreadMan getSpiderDetThreadMan() {
        return this.spiderDetThreadMan;
    }

    public SpiderLiThreadMan getSpiderLiThreadMan() {
        return this.spiderLiThreadMan;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public void setChromedriverLocation(String chromedriverLocation) {
        this.chromedriverLocation = chromedriverLocation;
    }

    public void setProxyConfigMapper(ProxyConfigMapper proxyConfigMapper) {
        this.proxyConfigMapper = proxyConfigMapper;
    }

    public void setSpiderDetThreadMan(SpiderDetThreadMan spiderDetThreadMan) {
        this.spiderDetThreadMan = spiderDetThreadMan;
    }

    public void setSpiderLiThreadMan(SpiderLiThreadMan spiderLiThreadMan) {
        this.spiderLiThreadMan = spiderLiThreadMan;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppInitRunner)) {
            return false;
        }
        AppInitRunner other = (AppInitRunner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$urls = this.getUrls();
        List<String> other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        String this$chromedriverLocation = this.getChromedriverLocation();
        String other$chromedriverLocation = other.getChromedriverLocation();
        if (this$chromedriverLocation == null ? other$chromedriverLocation != null : !this$chromedriverLocation.equals(other$chromedriverLocation)) {
            return false;
        }
        ProxyConfigMapper this$proxyConfigMapper = this.getProxyConfigMapper();
        ProxyConfigMapper other$proxyConfigMapper = other.getProxyConfigMapper();
        if (this$proxyConfigMapper == null ? other$proxyConfigMapper != null : !this$proxyConfigMapper.equals(other$proxyConfigMapper)) {
            return false;
        }
        SpiderDetThreadMan this$spiderDetThreadMan = this.getSpiderDetThreadMan();
        SpiderDetThreadMan other$spiderDetThreadMan = other.getSpiderDetThreadMan();
        if (this$spiderDetThreadMan == null ? other$spiderDetThreadMan != null : !this$spiderDetThreadMan.equals(other$spiderDetThreadMan)) {
            return false;
        }
        SpiderLiThreadMan this$spiderLiThreadMan = this.getSpiderLiThreadMan();
        SpiderLiThreadMan other$spiderLiThreadMan = other.getSpiderLiThreadMan();
        return !(this$spiderLiThreadMan == null ? other$spiderLiThreadMan != null : !this$spiderLiThreadMan.equals(other$spiderLiThreadMan));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppInitRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        String $chromedriverLocation = this.getChromedriverLocation();
        result = result * 59 + ($chromedriverLocation == null ? 43 : $chromedriverLocation.hashCode());
        ProxyConfigMapper $proxyConfigMapper = this.getProxyConfigMapper();
        result = result * 59 + ($proxyConfigMapper == null ? 43 : $proxyConfigMapper.hashCode());
        SpiderDetThreadMan $spiderDetThreadMan = this.getSpiderDetThreadMan();
        result = result * 59 + ($spiderDetThreadMan == null ? 43 : $spiderDetThreadMan.hashCode());
        SpiderLiThreadMan $spiderLiThreadMan = this.getSpiderLiThreadMan();
        result = result * 59 + ($spiderLiThreadMan == null ? 43 : $spiderLiThreadMan.hashCode());
        return result;
    }

    public String toString() {
        return "AppInitRunner(urls=" + this.getUrls() + ", chromedriverLocation=" + this.getChromedriverLocation() + ", proxyConfigMapper=" + this.getProxyConfigMapper() + ", spiderDetThreadMan=" + this.getSpiderDetThreadMan() + ", spiderLiThreadMan=" + this.getSpiderLiThreadMan() + ")";
    }
}

