/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.proxy;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DmdProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(DmdProxyUtil.class);
    private static String proxyUrl = "http://get.3ip.cn/dmgetip.asp?apikey=20473ba9&pwd=8b4ee9a3f3371b7602dd786b70b0b008&getnum=1&httptype=0&geshi=2&fenge=1&fengefu=&Contenttype=1&operate=all";
    private static RedisHelper redisHelper;

    @Autowired
    public void setRedisHelper(RedisHelper redisHelper) {
        DmdProxyUtil.redisHelper = redisHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getProxy() {
        String proxyIp = null;
        ArrayList<String> proxyIps = new ArrayList<String>();
        SimpleDateFormat date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String osName = System.getProperties().getProperty("os.name");
        boolean flag = false;
        try {
            while (CollectionUtils.isEmpty(proxyIps)) {
                Iterator iterator;
                HttpResponse httpResponse = HttpRequest.get((String)proxyUrl).execute();
                if (httpResponse.isOk()) {
                    String result = httpResponse.body();
                    log.info("\u4ee3\u7406\u8c03\u7528\u63a5\u53e3\u6210\u529f:" + result);
                    JSONObject object = JSONObject.parseObject((String)result);
                    JSONArray list = JSONObject.parseArray((String)object.getString("data"), (Feature[])new Feature[0]);
                    iterator = list.iterator();
                } else {
                    log.info("\u4ee3\u7406\u5931\u8d25:" + httpResponse.body());
                    continue;
                }
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    proxyIp = map.get("ip") + ":" + map.get("port");
                    flag = "Linux".equals(osName) ? DmdProxyUtil.ping(map.get("ip").toString(), 3) : true;
                    if (!flag) continue;
                    proxyIps.add(proxyIp);
                    String endtime = map.get("endtime").toString();
                    Long extime = date.parse(endtime).getTime();
                    Long nowdate = new Date().getTime();
                    Long time = (extime - nowdate) / 1000L - 20L;
                    redisHelper.set("spider_proxy_ip", (Object)proxyIp, time.longValue());
                }
            }
            return proxyIps;
        }
        catch (Exception e) {
            log.error("\u4ee3\u7406\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return proxyIps;
    }

    public int execOneCmd(String cmd) {
        int flag = 0;
        try {
            String[] command = new String[]{"/bin/sh", "-c", cmd};
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            flag = process.exitValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ping(String ipAddress, int pingTimes) {
        BufferedReader in = null;
        Runtime r = Runtime.getRuntime();
        String pingCommand = "ping " + ipAddress + " -c " + pingTimes;
        try {
            Process p = r.exec(pingCommand);
            if (p == null) {
                boolean bl = false;
                return bl;
            }
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int connectedCount = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                connectedCount += DmdProxyUtil.getCheckResult(line);
            }
            boolean bl = connectedCount == pingTimes;
            return bl;
        }
        catch (Exception ex) {
            log.info("ping ip\u5f02\u5e38", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int getCheckResult(String line) {
        Pattern pattern = Pattern.compile("(ttl=\\d+)", 2);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return 1;
        }
        return 0;
    }
}

