/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.proxy;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QgProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(QgProxyUtil.class);
    @Autowired
    private static RedisHelper redisHelper;
    private static String curl;

    @Autowired
    public void setRedisHelper(RedisHelper redisHelper) {
        QgProxyUtil.redisHelper = redisHelper;
    }

    public static List<String> getProxy() {
        ArrayList<String> proxyIps = new ArrayList<String>();
        try {
            String server = "";
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            HttpResponse rsp = HttpRequest.get((String)curl).execute();
            log.info("\u83b7\u53d6\u52a8\u6001\u4ee3\u7406\u7ed3\u6784:[{}]", (Object)rsp.body());
            if (rsp.isOk()) {
                String result = rsp.body();
                JSONObject object = JSONObject.parseObject((String)result);
                JSONArray list = JSONObject.parseArray((String)object.getString("data"), (Feature[])new Feature[0]);
                for (Map map : list) {
                    server = map.get("server") + "";
                    String deadline = map.get("deadline") + "";
                    proxyIps.add(server);
                    Long extime = date.parse(deadline).getTime();
                    Long nowdate = new Date().getTime();
                    Long time = (extime - nowdate) / 1000L - 20L;
                    redisHelper.set("spider_proxy_ip", (Object)server, time.longValue());
                }
            } else {
                log.info("\u4ee3\u7406\u5931\u8d25:" + rsp.body());
            }
        }
        catch (Exception e) {
            log.error("\u4ee3\u7406\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return proxyIps;
    }

    public static void main(String[] args) throws Exception {
        String url = "https://search.jd.com/Search?keyword=%E6%89%8B%E6%9C%BA&enc=utf-8&psort=3&page=3";
        Document doc = Jsoup.connect((String)url).maxBodySize(0).get();
        Elements ulList = doc.select("ul[class='gl-warp clearfix']");
        Elements liList = ulList.select("li[class='gl-item']");
        for (Element item : liList) {
            if (item.select("span[class='p-promo-flag']").text().trim().equals("\u5e7f\u544a")) continue;
            System.out.println(item.select("div[class='p-name p-name-type-2']"));
            System.out.println(item.select("div[class='p-name p-name-type-2']").select("em").text());
        }
    }

    static {
        curl = "https://share.proxy.qg.net/pool?key=7BB2CB81&num=1&area=&isp=&format=json&seq=&distinct=false&pwd=E827E686884A&pool=1";
    }
}

