/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.thread;

import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.config.configuration.MallMaxThreadProperties;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SpiderDetThreadMan
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SpiderDetThreadMan.class);
    private final RedisHelper redisHelper;
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;
    private final MallMaxThreadProperties mallMaxThreadProperties;
    private static final ConcurrentHashMap<String, ArrayList<Thread>> map = new ConcurrentHashMap();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(20);

    public SpiderDetThreadMan(RedisHelper redisHelper, CommodityInformationServiceFactory commodityInformationServiceFactory, MallMaxThreadProperties mallMaxThreadProperties) {
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
        this.redisHelper = redisHelper;
        this.mallMaxThreadProperties = mallMaxThreadProperties;
    }

    @PostConstruct
    public void init() {
        for (RedisCacheKey redisCacheKey : RedisCacheKey.values()) {
            map.put(redisCacheKey.getMall(), new ArrayList());
        }
    }

    @Override
    public void run() {
    }

    public int size(String key) {
        return map.get(key).size();
    }

    public int allSize() {
        int total = 0;
        for (ArrayList<Thread> value : map.values()) {
            total += value.size();
        }
        return total;
    }
}

