/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.ecs.model.v20140526.AllocateEipAddressRequest;
import com.aliyuncs.ecs.model.v20140526.AllocateEipAddressResponse;
import com.aliyuncs.ecs.model.v20140526.AssociateEipAddressRequest;
import com.aliyuncs.ecs.model.v20140526.AssociateEipAddressResponse;
import com.aliyuncs.ecs.model.v20140526.DescribeEipAddressesRequest;
import com.aliyuncs.ecs.model.v20140526.DescribeEipAddressesResponse;
import com.aliyuncs.ecs.model.v20140526.ReleaseEipAddressRequest;
import com.aliyuncs.ecs.model.v20140526.ReleaseEipAddressResponse;
import com.aliyuncs.ecs.model.v20140526.UnassociateEipAddressRequest;
import com.aliyuncs.ecs.model.v20140526.UnassociateEipAddressResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliApiUtil {
    private static final Logger log = LoggerFactory.getLogger(AliApiUtil.class);
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String regionId;
    private static String instanceId;

    @Value(value="${aliyun.spider.accessKeyId}")
    public void setAccessKeyId(String accessKeyId) {
        AliApiUtil.accessKeyId = accessKeyId;
    }

    @Value(value="${aliyun.spider.accessKeySecret}")
    public void setAccessKeySecret(String accessKeySecret) {
        AliApiUtil.accessKeySecret = accessKeySecret;
    }

    @Value(value="${aliyun.spider.regionId}")
    public void setRegionId(String regionId) {
        AliApiUtil.regionId = regionId;
    }

    @Value(value="${aliyun.spider.instanceId}")
    public void setInstanceId(String instanceId) {
        AliApiUtil.instanceId = instanceId;
    }

    public static DefaultAcsClient createClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    public static void associateEipAddress(DefaultAcsClient client, String allocationId) throws Exception {
        AssociateEipAddressRequest request = new AssociateEipAddressRequest();
        request.setInstanceId(instanceId);
        request.setAllocationId(allocationId);
        AssociateEipAddressResponse response = (AssociateEipAddressResponse)client.getAcsResponse((AcsRequest)request);
        log.info("EIP\u4e0eECS\u5b9e\u4f8b\u7ed1\u5b9a\u6210\u529f\uff0c\u8bf7\u6c42ID\uff1a" + response.getRequestId());
    }

    public static boolean describeEipAddresses(DefaultAcsClient client, String allocationId) throws Exception {
        List addressList;
        DescribeEipAddressesRequest request = new DescribeEipAddressesRequest();
        request.setAllocationId(allocationId);
        request.setAssociatedInstanceType("EcsInstance");
        boolean flag = false;
        DescribeEipAddressesResponse response = (DescribeEipAddressesResponse)client.getAcsResponse((AcsRequest)request);
        if (response.getTotalCount() > 0 && ((DescribeEipAddressesResponse.EipAddress)(addressList = response.getEipAddresses()).get(0)).getStatus().equals("InUse")) {
            log.info("ip:" + ((DescribeEipAddressesResponse.EipAddress)addressList.get(0)).getIpAddress());
            flag = true;
        }
        return flag;
    }

    public static void unassociateEipAddres(DefaultAcsClient client, String allocationId) throws Exception {
        UnassociateEipAddressRequest request = new UnassociateEipAddressRequest();
        request.setInstanceId(instanceId);
        request.setAllocationId(allocationId);
        UnassociateEipAddressResponse response = (UnassociateEipAddressResponse)client.getAcsResponse((AcsRequest)request);
        log.info("EIP\u4e0eECS\u5b9e\u4f8b\u89e3\u7ed1\u6210\u529f\uff0c\u8bf7\u6c42ID\uff1a" + response.getRequestId());
    }

    public static AllocateEipAddressResponse allocateEipAddress(DefaultAcsClient client) throws Exception {
        AllocateEipAddressRequest request = new AllocateEipAddressRequest();
        request.setInternetChargeType("PayByTraffic");
        request.setBandwidth("200");
        return (AllocateEipAddressResponse)client.getAcsResponse((AcsRequest)request);
    }

    public static void releaseEipAddress(DefaultAcsClient client, String allocationId) throws Exception {
        ReleaseEipAddressRequest request = new ReleaseEipAddressRequest();
        request.setAllocationId(allocationId);
        ReleaseEipAddressResponse response = (ReleaseEipAddressResponse)client.getAcsResponse((AcsRequest)request);
    }
}

