/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.yl.ddddocr.OCREngine;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.imageio.ImageIO;
import nu.pattern.OpenCV;
import org.apache.commons.codec.binary.Base64;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcuLateDistanceJDUtil {
    private static final Logger log = LoggerFactory.getLogger(CalcuLateDistanceJDUtil.class);

    public static void calcuLateDistance(RemoteWebDriver driver) {
        log.info("\u8fdb\u5165\u6ed1\u52a8\u9a8c\u8bc1");
        String filePath = "/app/shopping-spider/img/";
        String smallPath = filePath + System.currentTimeMillis() + "small.png";
        String bigPath = filePath + System.currentTimeMillis() + "big.png";
        String osName = System.getProperties().getProperty("os.name");
        if ("Windows 10".equals(osName)) {
            filePath = "D:\\img";
            smallPath = filePath + "\\" + System.currentTimeMillis() + "small.png";
            bigPath = filePath + "\\" + System.currentTimeMillis() + "big.png";
        }
        try {
            String smallUrl = driver.findElement(By.className((String)"JDJRV-smallimg")).findElement(By.tagName((String)"img")).getAttribute("src");
            String BgUrl = driver.findElement(By.className((String)"JDJRV-bigimg")).findElement(By.tagName((String)"img")).getAttribute("src");
            log.info("\u5f00\u59cb\u4e0b\u8f7d\u56fe\u7247");
            CalcuLateDistanceJDUtil.convertBase64StrToImage(smallUrl, smallPath);
            CalcuLateDistanceJDUtil.convertBase64StrToImage(BgUrl, bigPath);
            log.info("\u56fe\u7247\u4e0b\u8f7d\u5b8c\u6210");
            int slideDistance = CalcuLateDistanceJDUtil.getSlideDistance(smallPath, bigPath);
            log.info("\u9700\u8981\u79fb\u52a8\u7684\u8ddd\u79bb\u4e3a{}px", (Object)slideDistance);
            Actions actions = new Actions((WebDriver)driver);
            WebElement dragElement = driver.findElementByClassName("JDJRV-slide-btn");
            slideDistance = slideDistance * 278 / 360;
            log.info("\u7ecf\u8fc7\u6362\u7b97\u4e4b\u540e\u9700\u8981\u79fb\u52a8\u7684\u8ddd\u79bb\u4e3a{}px", (Object)slideDistance);
            actions.clickAndHold(dragElement).perform();
            List<Integer> moveTrack = CalcuLateDistanceJDUtil.getMoveTrack(slideDistance);
            for (Integer index : moveTrack) {
                actions.moveByOffset(index.intValue(), 0).perform();
            }
            actions.release().perform();
        }
        catch (Exception e) {
            log.info("\u6ed1\u52a8\u89e3\u9501\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public static void convertBase64StrToImage(String base64String, String imageFileName) {
        ByteArrayInputStream bais = null;
        try {
            String suffix = imageFileName.substring(imageFileName.lastIndexOf(".") + 1);
            base64String = base64String.split(";base64,")[1];
            byte[] bytes = Base64.decodeBase64((String)base64String);
            bais = new ByteArrayInputStream(bytes);
            BufferedImage bufferedImage = ImageIO.read(bais);
            File imageFile = new File(imageFileName);
            ImageIO.write((RenderedImage)bufferedImage, suffix, imageFile);
        }
        catch (Exception e) {
            throw new DcBusinessException("\u4e0b\u8f7d\u56fe\u7247\u5931\u8d25");
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getSlideDistance(String smallPath, String bigPath) {
        log.info("\u5f00\u59cb\u5904\u7406\u8ddd\u79bb");
        String osName = System.getProperties().getProperty("os.name");
        if ("Linux".equals(osName)) {
            String soPath = "/app/shopping-spider/libopencv_java320.so";
            log.info("\u52a0\u8f7d\u6587\u4ef6");
            System.load(soPath);
            log.info("\u52a0\u8f7d\u6587\u4ef6\u5b8c\u6bd5");
        } else {
            OpenCV.loadShared();
        }
        log.info("\u5bf9\u6ed1\u5757\u8fdb\u884c\u5904\u7406");
        Mat smallMat = Imgcodecs.imread((String)smallPath);
        log.info("\u7070\u5ea6\u5316\u56fe\u7247");
        Mat smallNewMat = new Mat();
        Imgproc.cvtColor((Mat)smallMat, (Mat)smallNewMat, (int)6);
        log.info("\u7070\u5ea6\u5316\u56fe\u7247");
        for (int row = 0; row < smallNewMat.height(); ++row) {
            for (int col = 0; col < smallNewMat.width(); ++col) {
                if (smallNewMat.get(row, col)[0] != 0.0) continue;
                smallNewMat.put(row, col, new double[]{96.0});
            }
        }
        log.info("\u4e8c\u503c\u5316\u8f6c\u9ed1\u767d\u56fe");
        Core.inRange((Mat)smallNewMat, (Scalar)Scalar.all((double)96.0), (Scalar)Scalar.all((double)96.0), (Mat)smallNewMat);
        log.info("\u5904\u7406\u80cc\u666f\u56fe");
        Mat slideBgMat = Imgcodecs.imread((String)bigPath);
        Imgproc.cvtColor((Mat)slideBgMat, (Mat)slideBgMat, (int)6);
        Imgproc.threshold((Mat)slideBgMat, (Mat)slideBgMat, (double)127.0, (double)255.0, (int)0);
        int result_rows = slideBgMat.rows() - smallNewMat.rows() + 1;
        int result_cols = slideBgMat.cols() - smallNewMat.cols() + 1;
        Mat g_result = new Mat(result_rows, result_cols, CvType.CV_32FC1);
        Imgproc.matchTemplate((Mat)slideBgMat, (Mat)smallNewMat, (Mat)g_result, (int)5);
        Core.normalize((Mat)g_result, (Mat)g_result, (double)0.0, (double)1.0, (int)32, (int)-1, (Mat)new Mat());
        Point matchLocation = new Point();
        Core.MinMaxLocResult mmlr = Core.minMaxLoc((Mat)g_result);
        matchLocation = mmlr.maxLoc;
        Imgproc.rectangle((Mat)slideBgMat, (Point)matchLocation, (Point)new Point(matchLocation.x + (double)smallNewMat.cols(), matchLocation.y + (double)smallNewMat.rows()), (Scalar)new Scalar(0.0, 255.0, 0.0, 0.0));
        log.info("\u6a2a\u5411\u8ddd\u79bb\u4e3a{}", (Object)matchLocation.x);
        return (int)matchLocation.x;
    }

    public static void move(WebDriver driver, WebElement element, int distance) throws InterruptedException {
        int randomTime = 0;
        if (distance > 90) {
            randomTime = 250;
        } else if (distance > 80 && distance <= 90) {
            randomTime = 200;
        }
        List<Integer> track = CalcuLateDistanceJDUtil.getMoveTrack(distance - 2);
        int moveY = 1;
        try {
            Actions actions = new Actions(driver);
            actions.clickAndHold(element).perform();
            Thread.sleep(500L);
            for (int i = 0; i < track.size(); ++i) {
                actions.moveByOffset(track.get(i).intValue(), moveY).perform();
                Thread.sleep(new Random().nextInt(300) + randomTime);
            }
            Thread.sleep(500L);
            actions.release(element).perform();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Integer> getMoveTrack(int distance) {
        ArrayList<Integer> track = new ArrayList<Integer>();
        Random random = new Random();
        int current = 0;
        int mid = distance * 4 / 5;
        int a = 0;
        int move = 0;
        while (true) {
            a = random.nextInt(10);
            move = current <= mid ? (move += a) : (move -= a);
            if (current + move >= distance) break;
            track.add(move);
            current += move;
        }
        track.add(distance - current);
        return track;
    }

    public static final Class getCurrentClass() {
        return new Object(){

            public Class getClassForStatic() {
                return this.getClass();
            }
        }.getClassForStatic();
    }

    public static void ehsyDistance(RemoteWebDriver driver) {
        try {
            String base64img = driver.findElementById("image-code").getAttribute("src");
            String result = CalcuLateDistanceJDUtil.getCode(base64img);
            driver.findElementById("auth-code").sendKeys(new CharSequence[]{result});
            driver.findElementByClassName("frequently__submit").click();
        }
        catch (Exception e) {
            driver.quit();
        }
    }

    public static String getCode(String base64) {
        try {
            base64 = base64.split(";base64,")[1];
            byte[] bytes = Base64.decodeBase64((String)base64);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            BufferedImage bufferedImage = ImageIO.read(bis);
            OCREngine ocrEngine = OCREngine.instance();
            return ocrEngine.recognize(bufferedImage);
        }
        catch (IOException e) {
            log.error("\u8bc6\u522b\u9a8c\u8bc1\u7801\u5f02\u5e38", (Throwable)e);
            return "";
        }
    }

    public static void moveZcygov(RemoteWebDriver driver) {
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
        WebElement element = (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"aliyunCaptcha-sliding-slider")));
        if (element != null) {
            Actions actions = new Actions((WebDriver)driver);
            int slideDistance = 280;
            actions.clickAndHold(element).perform();
            actions.moveByOffset(0, slideDistance).perform();
            actions.release().perform();
        }
    }
}

