/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ChineseCharactersUtils {
    public static String toFirstChar(String chinese) throws BadHanyuPinyinOutputFormatCombination {
        String pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            pinyinStr = newChar[i] > '\u0080' ? pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0) : pinyinStr + newChar[i];
        }
        return pinyinStr;
    }

    public static String toPinyin(String chinese) {
        String pinyinStr = "";
        try {
            char[] newChar = chinese.toCharArray();
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            for (char c : newChar) {
                if (Character.toString(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat);
                        if (pinyinArray != null && pinyinArray.length > 0) {
                            pinyinStr = pinyinStr + pinyinArray[0];
                            continue;
                        }
                        pinyinStr = pinyinStr + c;
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                        pinyinStr = pinyinStr + c;
                    }
                    continue;
                }
                pinyinStr = pinyinStr + c;
            }
            pinyinStr = pinyinStr.replace("\\", "_").replace("/", "_");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pinyinStr;
    }

    public static boolean containsChinese(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\u4e00' || c > '\u9fa5') continue;
            return true;
        }
        return false;
    }
}

