/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tydic.nicc.spider.config.aliyun.AliyunConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.imageio.ImageIO;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service
public class OssUploaderUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUploaderUtil.class);
    private final AliyunConfig aliyunConfig;

    @Autowired
    public OssUploaderUtil(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadScreenshot(WebDriver driver, String goodsno, String prefix) {
        OSS ossClient = null;
        try {
            Thread.sleep(500L);
            TakesScreenshot screenshotTaker = (TakesScreenshot)driver;
            JavascriptExecutor js = (JavascriptExecutor)driver;
            js.executeScript("window.scrollTo(0, 80);", new Object[0]);
            js.executeScript("document.body.style.zoom = '0.8';", new Object[0]);
            File screenshotFile = (File)screenshotTaker.getScreenshotAs(OutputType.FILE);
            BufferedImage bufferedImage = ImageIO.read(screenshotFile);
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.setColor(Color.RED);
            g2d.setFont(new Font("Arial", 1, 30));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = sdf.format(new Date());
            int x = bufferedImage.getWidth() - 30 - g2d.getFontMetrics().stringWidth(timestamp);
            int y = 60;
            g2d.drawString(timestamp, x, y);
            g2d.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            byte[] imageData = baos.toByteArray();
            String fileUrl = null;
            if (imageData.length > 0) {
                String ossObjectName = "spider/" + prefix + "_" + goodsno + "_" + LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE) + ".png";
                ossClient = new OSSClientBuilder().build(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentType("image/png");
                objectMetadata.setContentDisposition("inline; filename=" + ossObjectName);
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.aliyunConfig.getBucketName(), ossObjectName, (InputStream)new ByteArrayInputStream(imageData));
                PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
                putObjectRequest.setMetadata(objectMetadata);
                fileUrl = "https://" + this.aliyunConfig.getBucketName() + "." + this.aliyunConfig.getEndpoint() + "/" + ossObjectName;
            }
            String string = fileUrl;
            return string;
        }
        catch (Exception e) {
            log.info("\u4e0a\u4f20\u622a\u56fe\u5931\u8d25", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }
}

