/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.config.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.po.DcDataSourceInfoPO;
import com.tydic.nicc.spider.mapper.po.DcStrategyInfo;
import com.tydic.nicc.spider.mapper.po.DcTemplateInfoPOWithBLOBs;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.selector.Html;
import us.codecraft.webmagic.selector.Selectable;

public class TempUtil {
    private static final Logger log = LoggerFactory.getLogger(TempUtil.class);

    public static List<String> extractPlaceholderNames(String url) {
        ArrayList<String> placeholderNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            placeholderNames.add(matcher.group(1));
        }
        return placeholderNames;
    }

    public static String replacePlaceholders(String url, Map<String, String> placeholders) {
        Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");
        Matcher matcher = pattern.matcher(url);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholderName = matcher.group(1);
            String replacement = placeholders.getOrDefault(placeholderName, "");
            if (!StringUtils.isNotEmpty((CharSequence)replacement)) continue;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String requestHttpUrl(DcTemplateInfoPOWithBLOBs templateInfo, ObjectMapper mapper, DcStrategyInfo strategyInfo) {
        String result = "";
        try {
            if (templateInfo != null && templateInfo.getCrawlingMode().equals("API")) {
                HttpResponse response;
                HashMap headers = new HashMap();
                String url = templateInfo.getUrl();
                String headerStr = templateInfo.getHeader();
                String requestParam = templateInfo.getRequestParam();
                String host = "";
                int port = 0;
                if (StringUtils.isNotEmpty((CharSequence)headerStr)) {
                    List list = (List)mapper.readValue(headerStr, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
                    for (Map map : list) {
                        headers.put(map.get("code"), map.get("value"));
                    }
                }
                if (strategyInfo != null) {
                    if (StringUtils.isNotEmpty((CharSequence)strategyInfo.getProxyIp())) {
                        host = strategyInfo.getProxyIp().split(":")[0];
                        port = Integer.parseInt(strategyInfo.getProxyIp().split(":")[1]);
                    }
                    if (strategyInfo.getTaskInterval() != null) {
                        TimeUnit.SECONDS.sleep(strategyInfo.getTaskInterval().intValue());
                    }
                }
                HttpRequest httpRequest = null;
                httpRequest = templateInfo.getRequestMethod().equals("1") ? HttpRequest.post((String)url).body(requestParam) : HttpRequest.get((String)url);
                httpRequest.addHeaders(headers);
                if (StringUtils.isNotEmpty((CharSequence)host)) {
                    httpRequest.setHttpProxy(host, port);
                }
                if ((response = httpRequest.execute()).isOk()) {
                    result = response.body();
                    int startIndex = result.indexOf(123);
                    int endIndex = result.lastIndexOf(125);
                    if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                        result = result.substring(startIndex, endIndex + 1);
                    }
                } else {
                    log.info("\u8bf7\u6c42\u5931\u8d25:" + JSON.toJSONString((Object)response));
                    result = "8888";
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            result = "8888";
        }
        return result;
    }

    public static String detectJsonFormat(String input) {
        try {
            new JSONObject(input);
            return "JSON";
        }
        catch (JSONException e) {
            return "Not JSON";
        }
    }

    public static String getUrl(String dataSourceUrl, String url) {
        if (StringUtils.isNotEmpty((CharSequence)url) && !url.contains("http")) {
            url = url.contains("//") ? "https:" + url : dataSourceUrl + url;
        }
        if (url == null || url.length() <= 800) {
            return url;
        }
        return url.substring(0, 800);
    }

    public static RemoteWebDriver loginCookie(RemoteWebDriver driver, String token, String dataSourceUrl) {
        driver.get(dataSourceUrl);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String cookie = token;
        String domain = "." + TempUtil.extractDomain(dataSourceUrl);
        try {
            Date date = format.parse("2040-12-31 18:00:00");
            if (StringUtils.isNotEmpty((CharSequence)cookie)) {
                Cookie cookie1 = new Cookie(StringUtils.substringBefore((String)cookie, (String)"=").trim(), StringUtils.substringAfter((String)cookie, (String)"=").trim(), domain, null, date, true, true);
                driver.manage().addCookie(cookie1);
            }
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return driver;
    }

    public static String getStr(Selectable div, String str) {
        String string = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            try {
                String[] d = str.split(",");
                string = d.length == 2 ? div.$(d[0], d[1]).get() : div.$(str).xpath("///allText()").get();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5143\u7d20{}\u5931\u8d25", (Object)str, (Object)e);
            }
        }
        return string;
    }

    public static String getPrice(String price) {
        String result = "0";
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            try {
                String regex = "\\d+(\\.\\d*)?";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(price);
                if (matcher.find()) {
                    result = matcher.group();
                }
            }
            catch (Exception e) {
                log.error("\u5339\u914d\u6570\u5b57\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }

    public static String getInt(String price) {
        String result = "1";
        if (StringUtils.isNotEmpty((CharSequence)price)) {
            try {
                String regex = "\\d+";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(price);
                if (matcher.find()) {
                    result = matcher.group();
                }
            }
            catch (Exception e) {
                log.error("\u5339\u914d\u6570\u5b57\u5931\u8d25", (Throwable)e);
            }
        }
        return result;
    }

    public static String getPrice(Selectable div, String priceStr, boolean flag) {
        String price = "0";
        try {
            if (StringUtils.isNotEmpty((CharSequence)priceStr)) {
                if (priceStr.contains("+")) {
                    String[] prices;
                    if (flag) {
                        priceStr = priceStr.split(";")[1];
                    }
                    for (String pri : prices = priceStr.split("\\+")) {
                        price = price + TempUtil.getPrice(TempUtil.getStr(div, pri));
                    }
                } else if (priceStr.contains("/")) {
                    String[] prices = priceStr.split("\\/");
                    price = Double.valueOf(TempUtil.getPrice(TempUtil.getStr(div, prices[0]))) / Double.valueOf(prices[1]) + "";
                } else {
                    price = TempUtil.getPrice(TempUtil.getStr(div, priceStr));
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    price = "0";
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u4ef7\u683c{}\u5931\u8d25", (Object)priceStr, (Object)e);
        }
        return price;
    }

    public static String getSkuId(String url, String paramName) {
        if (url.contains("?") && StringUtils.isNotEmpty((CharSequence)paramName)) {
            Pattern pattern = Pattern.compile("(?:[?&]" + Pattern.quote(paramName) + "=)([^&]+)");
            Matcher matcher = pattern.matcher(url);
            if (matcher.find()) {
                return matcher.group(1);
            }
        } else {
            String specialChars = "!@#$%^&*()_-+={[}]|:;\"'<,.>?/~`\\";
            int lastDotIndex = url.lastIndexOf(46);
            if (lastDotIndex != -1) {
                url = url.substring(0, lastDotIndex);
            }
            for (int i = url.length() - 1; i >= 0; --i) {
                char c = url.charAt(i);
                if (!specialChars.contains(String.valueOf(c))) continue;
                return url.substring(i + 1);
            }
            return url;
        }
        return null;
    }

    public static String extractValue(String url, String paramName) {
        Pattern pattern;
        Matcher matcher;
        String categoryId = "";
        if (url.contains("?") && StringUtils.isNotEmpty((CharSequence)paramName) && (matcher = (pattern = Pattern.compile("(?:[?&]" + Pattern.quote(paramName) + "=)([^&]+)")).matcher(url)).find()) {
            categoryId = matcher.group(1);
        }
        if (StringUtils.isEmpty((CharSequence)categoryId)) {
            int lastIndexOfSlash = url.lastIndexOf(47);
            if (lastIndexOfSlash == -1) {
                throw new IllegalArgumentException("Invalid URL: no path segments found");
            }
            String lastPathSegment = url.substring(lastIndexOfSlash + 1);
            int dotIndex = lastPathSegment.lastIndexOf(46);
            if (dotIndex != -1) {
                lastPathSegment = lastPathSegment.substring(0, dotIndex);
            }
            categoryId = lastPathSegment;
        }
        return categoryId;
    }

    public static RemoteWebDriver startDriver(DcStrategyInfo strategyInfo, String url, DcDataSourceInfoPO infoPO) {
        RemoteWebDriver driver = null;
        try {
            String proxyIp = null;
            if (strategyInfo != null && StringUtils.isNotEmpty((CharSequence)strategyInfo.getProxyIp())) {
                proxyIp = strategyInfo.getProxyIp();
            }
            while (driver == null) {
                try {
                    driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.NORMAL, proxyIp).getDriver();
                }
                catch (Exception e) {
                    log.error("\u6d4f\u89c8\u5668\u542f\u52a8\u5f02\u5e38", (Throwable)e);
                }
            }
            WebDriverWait wait = new WebDriverWait(driver, 10L);
            if (infoPO != null && StringUtils.isNotEmpty((CharSequence)infoPO.getToken())) {
                driver = TempUtil.loginCookie(driver, infoPO.getToken(), infoPO.getUrl());
            }
            driver.get(infoPO.getUrl());
            driver.executeScript("window.open('" + url + "','newwindow')", new Object[0]);
            Set windowHandles = driver.getWindowHandles();
            Iterator iterator = windowHandles.iterator();
            iterator.next();
            String window = (String)iterator.next();
            log.info("\u6253\u5f00\u65b0\u7a97\u53e3");
            driver.switchTo().window(window);
            if (strategyInfo != null && strategyInfo.getTaskInterval() != null) {
                TimeUnit.SECONDS.sleep(strategyInfo.getTaskInterval().intValue());
            }
            return driver;
        }
        catch (Exception e) {
            log.error("\u6d4f\u89c8\u5668\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String getDriverStr(RemoteWebDriver driver, String str) {
        WebDriverWait wait = new WebDriverWait((WebDriver)driver, 20L);
        String string = "";
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            for (int num = 1; StringUtils.isEmpty((CharSequence)string) && num <= 3; ++num) {
                try {
                    String[] d = str.split(",");
                    if (d.length == 2) {
                        string = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)d[0])))).getAttribute(d[1]);
                        continue;
                    }
                    string = ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)str)))).getText();
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (!StringUtils.isEmpty((CharSequence)string)) continue;
                        Html html = new Html(driver.getPageSource());
                        string = TempUtil.getStr((Selectable)html, str);
                        continue;
                    }
                    catch (Exception e1) {
                        log.error("\u83b7\u53d6\u5143\u7d20{}\u5931\u8d25", (Object)str, (Object)e1);
                    }
                }
            }
        }
        return string;
    }

    public static String getDriverPrice(RemoteWebDriver driver, String priceStr, boolean flag) {
        String price = "0";
        try {
            if (StringUtils.isNotEmpty((CharSequence)priceStr)) {
                if (priceStr.contains("+")) {
                    String[] prices;
                    if (flag) {
                        priceStr = priceStr.split(";")[1];
                    }
                    for (String pri : prices = priceStr.split("\\+")) {
                        price = price + TempUtil.getPrice(TempUtil.getDriverStr(driver, pri));
                    }
                } else if (priceStr.contains("/")) {
                    String[] prices = priceStr.split("\\/");
                    price = Double.valueOf(TempUtil.getPrice(TempUtil.getDriverStr(driver, prices[0]))) / Double.valueOf(prices[1]) + "";
                } else {
                    price = TempUtil.getPrice(TempUtil.getDriverStr(driver, priceStr));
                }
                if (StringUtils.isEmpty((CharSequence)price)) {
                    price = "0";
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u4ef7\u683c{}\u5931\u8d25", (Object)priceStr, (Object)e);
        }
        return price;
    }

    public static String extractDomain(String url) {
        String hostname;
        int lastDotIndex;
        Pattern pattern = Pattern.compile("https?://([^/]+)/?");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find() && (lastDotIndex = (hostname = matcher.group(1)).indexOf(46)) > 0) {
            return hostname.substring(lastDotIndex + 1);
        }
        return null;
    }
}

