/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.goods.BzdetProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.GomeProcessor;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bzdet")
public class BzdetSpiderServicelmpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(BzdetSpiderServicelmpl.class);
    @Autowired
    private CategoryPipeline categoryPipeline;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsMapper goodsMapper;

    public void addCategory() {
    }

    public Rsp climbCommodityTabulate(SpiderBO param) {
        long startTime0 = System.currentTimeMillis();
        String categoryId = param.getCategoryId();
        try {
            StringBuilder url = new StringBuilder();
            url.append("https://b.zdet.net/mall/").append(categoryId).append(".html");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url.toString());
            GomeProcessor.processor(categoryPO, this.processDataPipeline, param.getExecutionNumber());
        }
        catch (Exception e) {
            log.error("\u5927\u6c5f\u79d1\u6280\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u5927\u6c5f\u79d1\u6280\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        CategoryPO categoryPO = new CategoryPO();
        try {
            String url = "https://b.zdet.net/mall/search?keyword=" + keyword;
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            BzdetProcessor.processor(categoryPO, this.processDataPipeline, executionNumber);
        }
        catch (Exception e) {
            log.error("\u5927\u6c5f\u79d1\u6280\u722c\u53d6\u641c\u7d22\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

