/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.description.ComixDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.ComixProcessor;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="comix")
public class ComixSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(ComixSpiderServiceImpl.class);
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Autowired
    private GoodsDetailPipeline goodsDetailPipeline;
    @Autowired
    private ComixDescriptionProcessor comixDescriptionProcessor;
    @Autowired
    private ComixProcessor comixProcessor;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(3);

    public void addCategory() {
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, null);
        }
        catch (Exception e) {
            log.error("Gaj\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.comixDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String executionNumber = spiderBO.getExecutionNumber();
        String keyword = spiderBO.getKeyword().replace("\n", "");
        try {
            String encodedText = URLEncoder.encode(keyword, StandardCharsets.UTF_8.toString());
            String url = "https://mro.qx.com/#/search?type=search&keys=" + encodedText;
            URLEncoder.encode(url, "utf-8");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setKeyword(keyword);
            categoryPO.setUrl(url);
            this.comixProcessor.process(categoryPO, executionNumber);
        }
        catch (Exception e) {
            log.error("\u9f50\u5fc3\u5546\u57ce\u722c\u53d6\u5173\u952e\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

