/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import cn.hutool.core.net.url.UrlBuilder;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.ItemMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.ItemPO;
import com.tydic.nicc.spider.vo.EcChngCategoryVO;
import com.tydic.nicc.spider.vo.EcChngGoodsResultVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.selector.JsonPathSelector;

@Service(value="ec")
public class EcChngSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(EcChngSpiderServiceImpl.class);
    @Autowired
    private RestApiHelper restApiHelper;
    @Resource
    private ItemMapper itemMapper;
    @Resource
    private CategoryMapper categoryMapper;

    public void addCategory() {
        String resBody = this.restApiHelper.get("http://mall.ec.chng.com.cn/scm-hn-oauth-web/obs/business/product/Catrgory/query?channelTypeCode=101", "", new HashMap());
        JSONObject resData = JSONObject.parseObject((String)resBody);
        List chngCategoryVOS = JSONObject.parseArray((String)resData.getString("data"), EcChngCategoryVO.class);
        ArrayList categoryList = Lists.newArrayList();
        this.categoryMapper.deleteBySign(MallType.EC_CHNG.getCode());
        this.parseCategorys(chngCategoryVOS, categoryList, 1);
        for (CategoryPO categoryPO : categoryList) {
            this.categoryMapper.addCategory(categoryPO);
        }
    }

    private void parseCategorys(List<EcChngCategoryVO> chngCategoryVOS, List<CategoryPO> categoryList, int level) {
        for (EcChngCategoryVO chngCategoryVO : chngCategoryVOS) {
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setCategoryId(String.valueOf(chngCategoryVO.getNodeid()));
            categoryPO.setPater(chngCategoryVO.getParentId());
            categoryPO.setLevel(Integer.valueOf(level));
            categoryPO.setName(chngCategoryVO.getNodeName());
            categoryPO.setCreatedBy("kk");
            categoryPO.setUpdatedBy("kk");
            categoryPO.setCreatedTime(new Date());
            categoryPO.setSign(MallType.EC_CHNG.getCode());
            HashMap<String, String> tmpVal = new HashMap<String, String>();
            tmpVal.put("id", categoryPO.getCategoryId());
            tmpVal.put("name", categoryPO.getName());
            try {
                String url = NiccCommonUtil.parseTemplate((String)"http://mall.ec.chng.com.cn/list?t=font&s={{id}}&des={{name}}", tmpVal);
                categoryPO.setUrl(url);
            }
            catch (Exception url) {
                // empty catch block
            }
            categoryList.add(categoryPO);
            if (chngCategoryVO.getChildNodeList() == null || chngCategoryVO.getChildNodeList().isEmpty()) continue;
            int tmpLevel = level + 1;
            this.parseCategorys(chngCategoryVO.getChildNodeList(), categoryList, tmpLevel);
        }
    }

    public String handleUrl(String param) {
        return null;
    }

    public void climbCommodityInformation(String param) {
        List<String> urls = Arrays.asList("http://mall.ec.chng.com.cn/list?keywords=\u53f0\u5f0f\u7535\u8111", "http://mall.ec.chng.com.cn/list?keywords=\u7852\u9f13", "http://mall.ec.chng.com.cn/list?keywords=\u58a8\u76d2", "http://mall.ec.chng.com.cn/list?keywords=\u7f51\u7edc\u8bbe\u5907", "http://mall.ec.chng.com.cn/list?keywords=\u6253\u5370\u673a", "http://mall.ec.chng.com.cn/list?t=font&s=25839&des=\u5ba4\u5185\u706f\u5177", "http://mall.ec.chng.com.cn/list?t=font&s=25841&des=\u5ba4\u5916\u706f\u5177", "http://mall.ec.chng.com.cn/list?t=font&s=25843&des=\u9632\u7206\u706f\u5177", "http://mall.ec.chng.com.cn/list?keywords=\u6253\u5370\u7eb8", "http://mall.ec.chng.com.cn/list?keywords=\u590d\u5370\u7eb8", "http://mall.ec.chng.com.cn/list?keywords=\u7a7a\u8c03", "http://mall.ec.chng.com.cn/list?t=font&s=26237&des=\u5de5\u4f5c\u670d", "http://mall.ec.chng.com.cn/list?t=font&s=26239&des=\u5b9e\u9a8c\u5ba4\u5927\u8902", "http://mall.ec.chng.com.cn/list?t=font&s=26245&des=\u9632\u5bd2\u670d", "http://mall.ec.chng.com.cn/list?t=font&s=26251&des=\u963b\u71c3\u670d", "http://mall.ec.chng.com.cn/list?keywords=\u6570\u7801\u8bbe\u5907\u7535\u6c60", "http://mall.ec.chng.com.cn/list?keywords=\u9502\u7535\u6c60", "http://mall.ec.chng.com.cn/list?keywords=\u5145\u7535\u7535\u6c60", "http://mall.ec.chng.com.cn/list?t=font&s=25801&des=\u91d1\u5c5e\u7f20\u7ed5\u57ab\u7247", "http://mall.ec.chng.com.cn/list?t=font&s=26217&des=\u590f\u5b63\u5b89\u5168\u978b", "http://mall.ec.chng.com.cn/list?t=font&s=26219&des=\u5b89\u5168\u978b", "http://mall.ec.chng.com.cn/list?t=font&s=26221&des=\u9632\u6ed1/\u9632\u6c34\u5b89\u5168\u978b", "http://mall.ec.chng.com.cn/list?t=font&s=26223&des=\u8fd0\u52a8\u5b89\u5168\u978b", "http://mall.ec.chng.com.cn/list?t=font&s=26225&des=\u7edd\u7f18\u978b", "http://mall.ec.chng.com.cn/list?t=font&s=26227&des=\u9632\u5bd2\u978b/\u9774", "http://mall.ec.chng.com.cn/list?t=font&s=26229&des=\u9632\u5316\u9774", "http://mall.ec.chng.com.cn/list?t=font&s=26231&des=\u7edd\u7f18\u9774", "http://mall.ec.chng.com.cn/list?t=font&s=25751&des=\u5185\u516d\u89d2\u87ba\u6813", "http://mall.ec.chng.com.cn/list?t=font&s=25755&des=\u5916\u516d\u89d2\u87ba\u6813", "http://mall.ec.chng.com.cn/list?t=font&s=25765&des=\u975e\u516d\u89d2\u87ba\u6813", "http://mall.ec.chng.com.cn/list?t=font&s=25767&des=\u53cc\u5934\u87ba\u6813", "http://mall.ec.chng.com.cn/list?keywords=\u710a\u6761", "http://mall.ec.chng.com.cn/list?keywords=\u710a\u4e1d", "http://mall.ec.chng.com.cn/list?t=font&s=25795&des=\u673a\u68b0\u5bc6\u5c01", "http://mall.ec.chng.com.cn/list?t=font&s=25797&des=\u9aa8\u67b6\u53ca\u65e0\u9aa8\u67b6\u6cb9\u5c01", "http://mall.ec.chng.com.cn/list?t=font&s=25805&des=\u586b\u6599\u5bc6\u5c01", "http://mall.ec.chng.com.cn/list?t=font&s=25761&des=\u87ba\u6bcd", "http://mall.ec.chng.com.cn/list?t=font&s=25763&des=\u57ab\u5708", "http://mall.ec.chng.com.cn/list?t=font&s=26173&des=\u9632\u62a4\u53e3\u7f69", "http://mall.ec.chng.com.cn/list?t=font&s=24963&des=\u5f00\u53e3\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24955&des=\u5185\u516d\u89d2\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24959&des=\u6d3b\u52a8\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24961&des=\u4e24\u7528\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24965&des=\u6885\u82b1\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24987&des=\u6572\u51fb\u6273\u624b", "http://mall.ec.chng.com.cn/list?t=font&s=24983&des=\u5c16\u5c3e\u68d8\u8f6e\u6273\u624b");
        for (String url : urls) {
            Map paramMap = UrlBuilder.of((String)url.trim()).getQuery().getQueryMap();
            ArrayList goodsResultVOS = Lists.newArrayList();
            this.fetchAllGoods(JSONObject.toJSONString((Object)paramMap), goodsResultVOS);
            log.info("{}", (Object)JSONObject.toJSONString((Object)goodsResultVOS));
            log.info("{}", (Object)goodsResultVOS.size());
        }
    }

    public static void main(String[] args) {
        JsonPathSelector jsonPathSelector = new JsonPathSelector("$.data.root");
        List retData = jsonPathSelector.selectList("{\"name\":\"123\",\"data\":{\"root\":[{\"a\":1},{\"a\":2}]}}");
        System.out.println(retData);
    }

    private void fetchAllGoods(String paramMap, List<EcChngGoodsResultVO> goodsResultVOS) {
        block6: {
            JSONObject param = JSONObject.parseObject((String)paramMap);
            try {
                param.put("limit", (Object)30);
                String resBody = this.restApiHelper.post("http://mall.ec.chng.com.cn/scm-hn-oauth-web/obs/business/product/ProductSearch/search", (Object)param);
                JSONObject resData = JSONObject.parseObject((String)resBody);
                if (!"200".equals(resData.getString("code"))) break block6;
                List tempList = JSONObject.parseArray((String)resData.getJSONObject("data").getJSONObject("result").getString("root"), EcChngGoodsResultVO.class);
                goodsResultVOS.addAll(tempList);
                try {
                    this.addGoods(param, "http://mall.ec.chng.com.cn/scm-hn-oauth-web/obs/business/product/ProductSearch/search", tempList);
                }
                catch (Exception e) {
                    log.error("\u5546\u54c1\u6dfb\u52a0\u5f02\u5e38:", (Throwable)e);
                }
                System.out.println(goodsResultVOS);
                if (tempList != null && tempList.size() == 30) {
                    Integer start = param.getInteger("start");
                    if (start == null) {
                        start = 0;
                    }
                    param.put("start", (Object)(start + 30));
                    String nextParam = JSONObject.toJSONString((Object)param);
                    this.fetchAllGoods(nextParam, goodsResultVOS);
                    break block6;
                }
                return;
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5f02\u5e38:paramMap = {}", (Object)paramMap, (Object)e);
            }
        }
    }

    private void addGoods(JSONObject param, String url, List<EcChngGoodsResultVO> goodsResultVOS) {
        String cid = param.getString("s");
        for (EcChngGoodsResultVO goodsResultVO : goodsResultVOS) {
            ItemPO itemPO = new ItemPO();
            itemPO.setSpu(goodsResultVO.getProdCode());
            itemPO.setSku(goodsResultVO.getSkuCode());
            itemPO.setTitle(goodsResultVO.getProductTitle());
            itemPO.setPrice("0");
            itemPO.setPic(goodsResultVO.getImageUrl());
            itemPO.setUrl(url);
            String[] categoryCodes = goodsResultVO.getCategoryCode().split(":");
            if (categoryCodes.length > 0) {
                itemPO.setCategoryId(categoryCodes[categoryCodes.length - 1]);
            } else {
                itemPO.setCategoryId(cid);
            }
            itemPO.setCategoryName(goodsResultVO.getCategoryName());
            itemPO.setSign(goodsResultVO.getSpecSign());
            itemPO.setCreated(new Date());
            itemPO.setSupplierName(goodsResultVO.getSupplierName());
            itemPO.setSign(MallType.EC_CHNG.getCode());
            itemPO.setMallType(MallType.EC_CHNG.getCode());
            this.itemMapper.insert(itemPO);
        }
    }
}

