/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.DlCategoryProcessorWithJsoup;
import com.tydic.nicc.spider.compoent.processor.description.DlDescriptionProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.DlProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.GbbProcessorWithSelfDriver;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="gbb")
public class GbbSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(GbbSpiderServiceImpl.class);
    @Resource
    private DlCategoryProcessorWithJsoup dlCategoryProcessorWithJsoup;
    @Resource
    private CategoryPipeline categoryPipeline;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private CategoryMapper categoryMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private CacheInfoServiceImpl cacheInfoServiceImpl;
    @Autowired
    private GbbProcessorWithSelfDriver gbbProcessorWithSelfDriver;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(3);

    public void addCategory() {
        String url = "https://b2b.nbdeli.com/";
        Spider.create((PageProcessor)this.dlCategoryProcessorWithJsoup).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
        log.info("\u5de5\u5e2e\u5e2e\u5546\u57ce\u5206\u7c7b\u4fe1\u606f\u722c\u53d6\u5b8c\u6210");
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        SelfDriver selfDriver;
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            if (BooleanUtils.isTrue((Boolean)MallState.DL.isState())) {
                return BaseRspUtils.createErrorRsp((String)"7777", (String)"\u5df2\u6682\u505c\u6267\u884c");
            }
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
            if (!Objects.isNull(categoryPO)) {
                DlProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u5de5\u5e2e\u5e2e{}\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u5de5\u5e2e\u5e2e\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryId);
        selfDriver.getDriver().quit();
        long endTime = System.currentTimeMillis();
        log.info("\u5de5\u5e2e\u5e2e\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}\u5206\u949f", (Object)TimeUnit.MILLISECONDS.toMinutes(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBo) {
        int size = 5000;
        String categoryId = spiderBo.getCategoryId();
        String executionNumber = spiderBo.getExecutionNumber();
        try {
            for (int pageNo = 1; pageNo < Integer.MAX_VALUE; ++pageNo) {
                List goodsList = this.goodsMapper.selectListByCategoryIdWithLimit(MallType.DL.getCode(), categoryId, (pageNo - 1) * size, size, executionNumber);
                if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                    log.info("\u5de5\u5e2e\u5e2e\u5546\u57ce \u5206\u9875\u67e5\u8be2\u5206\u7c7b{}\u5546\u54c1\u6570\u636e{}\u6761", (Object)categoryId, (Object)goodsList.size());
                    this.processDetailsWithSelfDriver(goodsList, spiderBo);
                }
                if (!CollectionUtils.isEmpty((Collection)goodsList) && goodsList.size() >= size) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u5de5\u5e2e\u5e2e{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void processDetailsWithSelfDriver(List<Goods> goodsList, SpiderBO spiderBO) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()), spiderBO);
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex), spiderBO);
                i = lastIndex;
                lastIndex = i + num;
            }
        }
        log.info("DlSpiderServiceImpl driver exit");
    }

    private void spiderDesc(List<Goods> goodsList, SpiderBO spiderBO) {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        String keyword = spiderBO.getKeyword();
        for (Goods goods : goodsList) {
            if (BooleanUtils.isTrue((Boolean)MallState.DL.isState())) break;
            try {
                Map<String, Object> dataMap = DlDescriptionProcessorWithSelfDriver.process(selfDriver.getDriver(), goods);
                if (Objects.isNull(dataMap)) continue;
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            catch (Exception e) {
                log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Object)selfDriver.hashCode());
                selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                log.error("\u66f4\u6362driver\u540e,selfDriver is {}", (Throwable)e);
            }
        }
        selfDriver.getDriver().close();
        selfDriver.getDriver().quit();
        map.put("goodsList", goodList);
        map.put("goodsDetailsList", goodsDetailsList);
        map.put("keyword", keyword);
        this.processDataPipeline.processDataMap(map);
    }

    public void climbProductInfoByCache() {
        RedisCacheKey redisCacheKey = RedisCacheKey.fromMall(MallType.DL.getCode());
        List<Goods> goodsList;
        while (!CollectionUtils.isEmpty(goodsList = this.cacheInfoServiceImpl.getGoodsCache(redisCacheKey, 50L))) {
            this.processDetailsWithSelfDriver(goodsList, null);
        }
        return;
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        RemoteWebDriver driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
        try {
            Map<String, Object> dataMap = DlDescriptionProcessorWithSelfDriver.process(driver, goods);
            if (!Objects.isNull(dataMap)) {
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", null);
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("\u5de5\u5e2e\u5e2e\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String executionNumber = spiderBO.getExecutionNumber();
        String keyword = spiderBO.getKeyword().replace("\n", "");
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        try {
            String url = "https://www.gongbangbang.com/list/k_" + keyword;
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setKeyword(keyword);
            categoryPO.setUrl(url);
            this.gbbProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver, executionNumber);
            selfDriver.getDriver().quit();
        }
        catch (Exception e) {
            log.error("\u5de5\u90a6\u90a6\u722c\u53d6\u5173\u952e\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            if (selfDriver.getDriver() != null) {
                try {
                    selfDriver.getDriver().quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

