/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.JdCategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.JdCategoryProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.description.JdDescriptionProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.JdProcessorWithSelfDriver;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.DcDataSourceInfoMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.DcDataSourceInfoPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import com.tydic.nicc.spider.vo.JdCategoryVO;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="jd")
public class JdSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(JdSpiderServiceImpl.class);
    private final JdCategoryPipeline jdCategoryPipeline;
    private final ProcessDataPipeline processDataPipeline;
    private final CacheInfoServiceImpl cacheInfoServiceImpl;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private CategoryMapper categoryMapper;
    @Value(value="${aliyun.spider.enable}")
    private boolean enable;
    @Autowired
    private DcDataSourceInfoMapper dcDataSourceInfoMapper;
    @Autowired
    private JdProcessorWithSelfDriver jdProcessorWithSelfDriver;
    @Autowired
    private JdDescriptionProcessorWithSelfDriver jdDescriptionProcessorWithSelfDriver;

    public JdSpiderServiceImpl(JdCategoryPipeline jdCategoryPipeline, ProcessDataPipeline processDataPipeline, CacheInfoServiceImpl cacheInfoServiceImpl) {
        this.jdCategoryPipeline = jdCategoryPipeline;
        this.processDataPipeline = processDataPipeline;
        this.cacheInfoServiceImpl = cacheInfoServiceImpl;
    }

    public void addCategory() {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        try {
            Map<String, List<Map<String, List<JdCategoryVO>>>> dataMap = JdCategoryProcessorWithSelfDriver.process(selfDriver);
            this.jdCategoryPipeline.process(dataMap);
        }
        catch (Exception e) {
            log.error("addCategory is error {}", (Object)e.getMessage());
        }
        finally {
            if (selfDriver.getDriver() != null) {
                try {
                    selfDriver.getDriver().quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b\u4fe1\u606f\u722c\u53d6\u5b8c\u6210");
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        SelfDriver selfDriver;
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
            if (!Objects.isNull(categoryPO)) {
                this.jdProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u4eac\u4e1c\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryId);
        selfDriver.getDriver().quit();
        long endTime = System.currentTimeMillis();
        log.info("\u4eac\u4e1c\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}\u5206\u949f", (Object)TimeUnit.MILLISECONDS.toMinutes(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        String categoryId = spiderBO.getCategoryId();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List goodsList = this.goodsMapper.selectListByCategoryId(MallType.JD.getCode(), categoryId, executionNumber);
            log.info("\u4eac\u4e1c\u5546\u57ce{}\u5206\u7c7b\u4e0b\u5217\u8868\u6570\u636e\u5927\u5c0f\u4e3a\uff1a{}", (Object)categoryId, (Object)goodsList.size());
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                this.processCacheDet(goodsList, null);
            }
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u5206\u7c7b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void processCacheDet(List<Goods> goodsList, String keyword) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
                i = lastIndex;
                lastIndex = i + num;
            }
        }
        log.info("JdSpiderServiceImpl driver exit");
    }

    private void spiderDesc(List<Goods> goodsList, String keyword) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        for (Goods goods : goodsList) {
            try {
                Map<String, Object> dataMap = this.jdDescriptionProcessorWithSelfDriver.process(selfDriver.getDriver(), goods);
                if (Objects.isNull(dataMap)) continue;
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                if (goods1 != null && goods1.getGoodsNo() != null) {
                    goodList.add(goods1);
                }
                if (goodsDetailsWithBLOBs == null || goodsDetailsWithBLOBs.getGoodsNo() == null) continue;
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            catch (Exception e) {
                selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Throwable)e);
            }
        }
        try {
            selfDriver.getDriver().quit();
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25", (Throwable)e);
        }
        map.put("goodsList", goodList);
        map.put("goodsDetailsList", goodsDetailsList);
        map.put("keyword", keyword);
        this.processDataPipeline.processDataMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        RemoteWebDriver driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
        Goods goods1 = null;
        try {
            Map<String, Object> dataMap = this.jdDescriptionProcessorWithSelfDriver.process(driver, goods);
            if (!Objects.isNull(dataMap)) {
                goods1 = (Goods)dataMap.get("goods");
                for (int num = 1; goods1 != null && goods1.getPrice() != null && goods1.getSkuState().equals("1") && goods1.getPrice().intValue() == 0 && num <= 3; ++num) {
                    dataMap = this.jdDescriptionProcessorWithSelfDriver.process(driver, goods);
                    goods1 = (Goods)dataMap.get("goods");
                }
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", null);
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25", (Throwable)e);
                driver.quit();
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String exNumber = spiderBO.getExecutionNumber();
        try {
            String url = "https://search.jd.com/Search?keyword=" + keyword + "&enc=utf-8";
            URLEncoder.encode(url, "utf-8");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            this.jdProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, selfDriver, exNumber);
            selfDriver.getDriver().quit();
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u722c\u53d6\u641c\u7d22\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            try {
                selfDriver.getDriver().quit();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25", (Throwable)e);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public RemoteWebDriver loginCookie(RemoteWebDriver driver) {
        driver.get("https://jd.com/");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String cookie = null;
        try {
            DcDataSourceInfoPO dcDataSourceInfoPO = this.dcDataSourceInfoMapper.selectBySign(MallType.JD.getCode());
            if (dcDataSourceInfoPO != null && StringUtils.isNotEmpty((CharSequence)dcDataSourceInfoPO.getToken())) {
                cookie = dcDataSourceInfoPO.getToken();
            }
            Date date = format.parse("2040-12-31 18:00:00");
            if (StringUtils.isNotEmpty(cookie)) {
                Cookie cookie1 = new Cookie(StringUtils.substringBefore((String)cookie, (String)"=").trim(), StringUtils.substringAfter((String)cookie, (String)"=").trim(), ".jd.com", null, date, true, true);
                driver.manage().addCookie(cookie1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return driver;
    }
}

