/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.OfsCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.OfsDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.GomeProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.OfsProcessorDriver;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="ofs")
public class OfsSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(OfsSpiderServiceImpl.class);
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private OfsCategoryProcessor ofsCategoryProcessor;
    @Autowired
    private CategoryPipeline categoryPipeline;
    @Autowired
    private OfsProcessorDriver ofsProcessorDriver;
    @Autowired
    private OfsDescriptionProcessor ofsDescriptionProcessor;
    @Autowired
    private GoodsDetailPipeline goodsDetailPipeline;

    public void addCategory() {
        String url = "https://www.ofs.cn/index.html";
        Spider.create((PageProcessor)this.ofsCategoryProcessor).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime0 = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        try {
            StringBuilder url = new StringBuilder();
            url.append("https://list.gome.com.cn/").append(categoryId).append(".html");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url.toString());
            GomeProcessor.processor(categoryPO, this.processDataPipeline, parameter.getExecutionNumber());
        }
        catch (Exception e) {
            log.error("\u56fd\u7f8e\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u56fd\u7f8e\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        String categoryId = spiderBO.getCategoryId();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List goodsList = this.goodsMapper.selectListByCategoryId(MallType.Gome.getCode(), categoryId, executionNumber);
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                this.spiderDescPro(goodsList, spiderBO.getKeyword());
            } else {
                log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
            }
        }
        catch (Exception e) {
            log.error("gome{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void spiderDescPro(List<Goods> goodsList, String keyword) {
        int num;
        int lastIndex = num = 100;
        int i = 0;
        while (i < goodsList.size()) {
            if (lastIndex >= goodsList.size()) {
                this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                break;
            }
            this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
            i = lastIndex;
            lastIndex = i + num;
        }
    }

    private void spiderDesc(List<Goods> goodsList, String keyword) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("goodsList", goodsList);
        if (CollectionUtils.isNotEmpty(goodsList)) {
            for (Goods goods : goodsList) {
                try {
                    this.spiderDetail(hashMap, goods, keyword);
                }
                catch (Exception e) {
                    log.error("\u56fd\u7f8e\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            }
            long endTime = System.currentTimeMillis();
            log.info("\u56fd\u7f8e\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> map, Goods goods, String keyword) {
        try {
            Request request = new Request();
            map.put("goods", goods);
            request.setUrl(goods.getUrl());
            request.setExtras(map);
            request.putExtra("keyword", (Object)keyword);
            Spider.create((PageProcessor)this.ofsDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
        }
        catch (Exception e) {
            log.error("ofs\u722c\u53d6\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            String encodedText = URLEncoder.encode(keyword, StandardCharsets.UTF_8.toString());
            String url = "https://www.ofs.cn/gallery.html?scontent=n," + encodedText;
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            if (keyword.length() >= 7 && keyword.chars().allMatch(Character::isDigit) || keyword.startsWith("FK")) {
                HashMap<String, Goods> hashMap = new HashMap<String, Goods>();
                Request request = new Request();
                Goods goods = new Goods();
                goods.setGoodsNo(keyword);
                goods.setUrl(url);
                hashMap.put("goods", goods);
                request.setUrl(url);
                request.setExtras(hashMap);
                request.putExtra("keyword", (Object)keyword);
                Spider.create((PageProcessor)this.ofsDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
            }
            this.ofsProcessorDriver.process(categoryPO, executionNumber);
        }
        catch (Exception e) {
            log.error("ofs\u529e\u516c\u7528\u54c1\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, goods, null);
        }
        catch (Exception e) {
            log.error("\u56fd\u7f8e\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

