/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.processor.goods.QstbgProcessor;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="qstbg")
public class QstbgSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(QstbgSpiderServiceImpl.class);
    @Resource
    private QstbgProcessor qstbgProcessor;

    public void addCategory() {
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String executionNumber = spiderBO.getExecutionNumber();
        long startTime0 = System.currentTimeMillis();
        String categoryId = spiderBO.getCategoryId();
        String keyword = spiderBO.getKeyword();
        try {
            StringBuilder url = new StringBuilder();
            String encodedText = URLEncoder.encode(keyword, StandardCharsets.UTF_8.toString());
            url.append("https://www.qstbg.com/gd/search/index.do?goods_name=").append(encodedText);
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(String.valueOf(url));
            categoryPO.setKeyword(keyword);
            this.qstbgProcessor.process(categoryPO, executionNumber);
        }
        catch (Exception e) {
            log.error("\u4f01\u4e8b\u901a\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u4f01\u4e8b\u901a\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

