/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.spider.api.RedisService;
import com.tydic.nicc.spider.mapper.UnsplashPicMapper;
import com.tydic.nicc.spider.mapper.po.UnsplashPic;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Autowired
    private UnsplashPicMapper unsplashPicMapper;

    public void unsplash(String keyword) {
        block7: {
            try {
                if (!StringUtils.isNotEmpty((CharSequence)keyword)) break block7;
                String encoder = URLEncoder.encode(keyword, "UTF-8");
                int page = 1;
                String url = "https://unsplash.com/napi/search/photos?page=" + page + "&per_page=30&query=" + encoder;
                HttpResponse response = HttpRequest.get((String)url).execute();
                if (response.isOk()) {
                    String result = response.body();
                    if (!StringUtils.isNotEmpty((CharSequence)result)) break block7;
                    JSONObject json = JSONObject.parseObject((String)result);
                    JSONArray picList = json.getJSONArray("results");
                    this.spiderUnsplashPicDetail(picList, keyword);
                    String totalPageStr = json.getString("total_pages");
                    if (!StringUtils.isNotEmpty((CharSequence)totalPageStr)) break block7;
                    int totalPage = Integer.parseInt(totalPageStr);
                    if (totalPage > 4) {
                        totalPage = 4;
                    }
                    if (totalPage <= 1) break block7;
                    for (int i = 2; i < totalPage + 1; ++i) {
                        url = "https://unsplash.com/napi/search/photos?page=" + i + "&per_page=30&query=" + encoder;
                        response = HttpRequest.get((String)url).execute();
                        if (response.isOk()) {
                            result = response.body();
                            if (!StringUtils.isNotEmpty((CharSequence)result)) continue;
                            json = JSONObject.parseObject((String)result);
                            picList = json.getJSONArray("results");
                            if (picList != null && picList.size() != 0) {
                                this.spiderUnsplashPicDetail(picList, keyword);
                                continue;
                            }
                            break block7;
                        }
                        log.error("{}\u7b2c{}\u9875\u83b7\u53d6\u6570\u636e\u5931\u8d25{}", new Object[]{keyword, i, response.body()});
                    }
                    break block7;
                }
                log.error("{}\u7b2c\u4e00\u9875\u83b7\u53d6\u6570\u636e\u5931\u8d25{}", (Object)keyword, (Object)response.body());
            }
            catch (Exception e) {
                log.error("\u641c\u7d22{}\u5931\u8d25", (Object)keyword, (Object)e);
            }
        }
    }

    private void spiderUnsplashPicDetail(JSONArray picList, String keyword) {
        ArrayList<UnsplashPic> pics = new ArrayList<UnsplashPic>();
        if (picList != null && picList.size() > 0) {
            for (int i = 0; i < picList.size(); ++i) {
                JSONObject pic = picList.getJSONObject(i);
                String slug = pic.getString("slug");
                String picApi = "https://unsplash.com/napi/photos/" + slug;
                JSONObject links = pic.getJSONObject("links");
                UnsplashPic unsplashPic = new UnsplashPic();
                unsplashPic.setKeyword(keyword);
                unsplashPic.setPicId(pic.getString("id"));
                unsplashPic.setPicDownload(links.getString("download"));
                unsplashPic.setPicHtml(links.getString("html"));
                unsplashPic.setAltDescription(pic.getString("alt_description"));
                unsplashPic.setDescription(pic.getString("description"));
                unsplashPic.setPicApi(picApi);
                HttpResponse response = HttpRequest.get((String)picApi).execute();
                if (response.isOk()) {
                    String result = response.body();
                    JSONArray tags = JSONObject.parseObject((String)result).getJSONArray("tags");
                    String label = "";
                    if (tags != null && tags.size() > 0) {
                        for (int j = 0; j < tags.size(); ++j) {
                            String value = tags.getJSONObject(j).getString("title");
                            label = label + value + ";";
                        }
                    }
                    unsplashPic.setPicLabel(label);
                }
                pics.add(unsplashPic);
            }
            try {
                this.unsplashPicMapper.insertBatch(pics);
            }
            catch (Exception e) {
                log.error("\u5931\u8d25", (Throwable)e);
            }
        } else {
            log.info("\u6570\u636e\u4e3a\u7a7a");
        }
    }
}

