/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.SnCategoryProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.description.SnDescriptionProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.SnProcessorWithSelfDriver;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import com.tydic.nicc.spider.vo.SelfDriver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="suning")
public class SnSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(SnSpiderServiceImpl.class);
    private final SnCategoryProcessorWithSelfDriver snCategoryProcessorWithSelfDriver;
    private final CategoryPipeline categoryPipeline;
    private final ProcessDataPipeline processDataPipeline;
    private final CacheInfoServiceImpl cacheInfoServiceImpl;
    @Resource
    private CategoryMapper categoryMapper;
    @Resource
    private GoodsMapper goodsMapper;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void addCategory() {
        String url = "https://list.suning.com";
        Spider.create((PageProcessor)this.snCategoryProcessorWithSelfDriver).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
        log.info("\u82cf\u5b81\u5546\u57ce\u5206\u7c7b\u4fe1\u606f\u722c\u53d6\u5b8c\u6210");
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        SelfDriver selfDriver;
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
            if (!Objects.isNull(categoryPO)) {
                SnProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, executorService, selfDriver, executionNumber);
            }
            log.info("\u82cf\u5b81\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryId);
        }
        catch (Exception e) {
            log.error("\u82cf\u5b81\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        selfDriver.getDriver().quit();
        long endTime = System.currentTimeMillis();
        log.info("\u82cf\u5b81\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}\u5206\u949f", (Object)TimeUnit.MILLISECONDS.toMinutes(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        String categoryId = spiderBO.getCategoryId();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List goodsList = this.goodsMapper.selectListByCategoryId(MallType.Sn.getCode(), categoryId, executionNumber);
            log.info("\u82cf\u5b81\u5546\u57ce{}\u5206\u7c7b\u4e0b\u5217\u8868\u6570\u636e\u5927\u5c0f\u4e3a\uff1a{}", (Object)categoryId, (Object)goodsList.size());
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                this.processDetailsWithSelfDriver(goodsList, null);
            }
        }
        catch (Exception e) {
            log.error("suning\u5206\u7c7b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void processDetailsWithSelfDriver(List<Goods> goodsList, String keyword) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
                i = lastIndex;
                lastIndex = i + num;
            }
        }
        log.info("SnSpiderServiceImpl driver exit");
    }

    private void spiderDesc(List<Goods> goodsList, String keyword) {
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.NORMAL, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        for (Goods goods : goodsList) {
            if (BooleanUtils.isTrue((Boolean)MallState.Sn.isState())) break;
            try {
                Map<String, Object> dataMap = SnDescriptionProcessorWithSelfDriver.process(selfDriver.getDriver(), goods);
                if (Objects.isNull(dataMap)) continue;
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            catch (Exception e) {
                selfDriver.getDriver().quit();
                log.error("\u66f4\u6362driver\u524d,selfDriver is {}", (Object)selfDriver.hashCode());
                selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
                log.error("\u66f4\u6362driver\u540e,selfDriver is {}", (Object)selfDriver.hashCode());
            }
        }
        selfDriver.getDriver().quit();
        map.put("goodsList", goodList);
        map.put("goodsDetailsList", goodsDetailsList);
        map.put("keyword", keyword);
        this.processDataPipeline.processDataMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        RemoteWebDriver driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
        try {
            Map<String, Object> dataMap = SnDescriptionProcessorWithSelfDriver.process(driver, goods);
            if (!Objects.isNull(dataMap)) {
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", null);
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("\u82cf\u5b81\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            if (driver != null) {
                try {
                    driver.quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        String url = "https://search.suning.com/" + keyword + "/";
        SelfDriver selfDriver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null);
        try {
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            SnProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, executorService, selfDriver, executionNumber);
            selfDriver.getDriver().quit();
        }
        catch (Exception e) {
            log.error("\u82cf\u5b81\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            if (selfDriver.getDriver() != null) {
                try {
                    selfDriver.getDriver().quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public SnSpiderServiceImpl(SnCategoryProcessorWithSelfDriver snCategoryProcessorWithSelfDriver, CategoryPipeline categoryPipeline, ProcessDataPipeline processDataPipeline, CacheInfoServiceImpl cacheInfoServiceImpl, CategoryMapper categoryMapper, GoodsMapper goodsMapper) {
        this.snCategoryProcessorWithSelfDriver = snCategoryProcessorWithSelfDriver;
        this.categoryPipeline = categoryPipeline;
        this.processDataPipeline = processDataPipeline;
        this.cacheInfoServiceImpl = cacheInfoServiceImpl;
        this.categoryMapper = categoryMapper;
        this.goodsMapper = goodsMapper;
    }
}

