/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.ecs.model.v20140526.AllocateEipAddressResponse;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.RedisService;
import com.tydic.nicc.spider.api.SpiderService;
import com.tydic.nicc.spider.api.SpiderTempService;
import com.tydic.nicc.spider.api.bo.CategoryBO;
import com.tydic.nicc.spider.api.bo.DataSkuInfo;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.KeywordReqBO;
import com.tydic.nicc.spider.api.bo.QueryGoodByKeywordReqBO;
import com.tydic.nicc.spider.api.bo.QuerySkuByTaskNumberReqBO;
import com.tydic.nicc.spider.api.bo.ReceiveSkuInfo;
import com.tydic.nicc.spider.api.bo.SkuInfoBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.api.bo.SpiderParameterBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.config.factory.CommodityInformationServiceFactory;
import com.tydic.nicc.spider.config.util.AliApiUtil;
import com.tydic.nicc.spider.config.util.ProcessRegexUtil;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.DcCrawlOptionsInfoMapper;
import com.tydic.nicc.spider.mapper.DcDataSourceInfoMapper;
import com.tydic.nicc.spider.mapper.DcTaskExecutionInfoMapper;
import com.tydic.nicc.spider.mapper.DcTemplateInfoMapper;
import com.tydic.nicc.spider.mapper.GoodsDetailsMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.SpiderEipMapper;
import com.tydic.nicc.spider.mapper.SpiderLogMapper;
import com.tydic.nicc.spider.mapper.SpiderSyncLogMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.DcCrawlOptionsInfoPO;
import com.tydic.nicc.spider.mapper.po.DcDataSourceInfoPO;
import com.tydic.nicc.spider.mapper.po.DcTaskExecutionInfoPO;
import com.tydic.nicc.spider.mapper.po.DcTemplateInfoPOWithBLOBs;
import com.tydic.nicc.spider.mapper.po.SpiderEipPO;
import com.tydic.nicc.spider.mapper.po.SpiderLogPO;
import com.tydic.nicc.spider.mapper.po.SpiderSyncLogPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SpiderServiceImpl
implements SpiderService {
    private static final Logger log = LoggerFactory.getLogger(SpiderServiceImpl.class);
    @Autowired
    private RedisHelper redisHelper;
    private Object lock = new Object();
    @Resource
    private CategoryMapper categoryMapper;
    @Resource
    private SpiderLogMapper spiderLogMapper;
    @Autowired
    private SpiderEipMapper spiderEipMapper;
    @Autowired
    private SpiderSyncLogMapper syncLogMapper;
    @Autowired
    private DcDataSourceInfoMapper dcDataSourceInfoMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsDetailsMapper goodsDetailsMapper;
    @Autowired
    private DcTaskExecutionInfoMapper dcTaskExecutionInfoMapper;
    @Autowired
    private DcCrawlOptionsInfoMapper dcCrawlOptionsInfoMapper;
    @Value(value="${aliyun.spider.instanceId}")
    private String instanceId;
    @Value(value="${isSingleExecute}")
    private boolean isSingleExecute;
    @Value(value="${identificationName}")
    private String identificationName;
    @Value(value="${nicc-plugin.spider.tascrawlkurl}")
    private String tascrawlkurl;
    @Autowired
    private RedissonClient redissonClient;
    private final CommodityInformationServiceFactory commodityInformationServiceFactory;
    @Autowired
    private SpiderTempService spiderTempService;
    @Autowired
    private DcTemplateInfoMapper dcTemplateInfoMapper;
    @Autowired
    private RedisService redisService;
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);

    public SpiderServiceImpl(CommodityInformationServiceFactory commodityInformationServiceFactory) {
        this.commodityInformationServiceFactory = commodityInformationServiceFactory;
    }

    public Rsp receiveSkuInfo(DataSkuInfo reqBO) {
        try {
            this.redisHelper.lSet("spider_receiveSkuInfo", (Object)reqBO);
            List skuInfos = reqBO.getData().getSkuInfos();
            if (CollectionUtils.isNotEmpty((Collection)skuInfos)) {
                SpiderSyncLogPO syncLogPO = SpiderSyncLogPO.builder().createTime(new Date()).sign(reqBO.getPoolName()).spiderType("0").executionNumber(reqBO.getSerialNo()).build();
                for (SkuInfoBO skuInfoBO : skuInfos) {
                    syncLogPO.setGoodsNo(skuInfoBO.getSkuId());
                    syncLogPO.setUrl(skuInfoBO.getExtLink());
                    this.syncLogMapper.insertSelective(syncLogPO);
                }
            }
        }
        catch (Exception e) {
            log.error("redis set\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp queryGoodByKeyword(QueryGoodByKeywordReqBO reqBO) {
        try {
            this.redisHelper.lSet("spider_keyword", (Object)reqBO);
        }
        catch (Exception e) {
            log.error("redis set\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public RspList<CategoryBO> queryNewCategory() {
        ArrayList<GoodsBO> goodsBOList = new ArrayList<GoodsBO>();
        try {
            List categoryPOList = this.categoryMapper.selectNewCategory();
            if (CollectionUtils.isNotEmpty((Collection)categoryPOList)) {
                for (CategoryPO categoryPO : categoryPOList) {
                    GoodsBO goodsBO = GoodsBO.builder().build();
                    BeanUtils.copyProperties((Object)categoryPO, (Object)goodsBO);
                    goodsBOList.add(goodsBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u65b0\u5206\u7c7b\u5f02\u5e38", (Throwable)e);
        }
        return BaseRspUtils.createSuccessRspList(goodsBOList);
    }

    public List<String> querySpiderLog(SpiderParameterBO reqBO) {
        String mall = reqBO.getMall();
        List categoryIdList = reqBO.getCategoryIdList();
        List<Object> allCategoryIdList = new ArrayList();
        this.spiderLogMapper.deleteBySign(mall);
        if (CollectionUtils.isEmpty((Collection)categoryIdList)) {
            List categoryList;
            SpiderLogPO spiderLogPO = this.spiderLogMapper.selectBySignAndType(mall, reqBO.getExtraUrlParam());
            if (spiderLogPO != null && spiderLogPO.getCategoryId() != null) {
                if (spiderLogPO.getSpiderType().equals("2") && !spiderLogPO.getCurrentPage().equals(spiderLogPO.getTotalPage())) {
                    allCategoryIdList.add(spiderLogPO.getCategoryId());
                }
                List list = this.categoryMapper.selectCategoryIdListById(mall, spiderLogPO.getCategoryId());
                allCategoryIdList.addAll(list);
            }
            if (CollectionUtils.isEmpty(allCategoryIdList) && CollectionUtils.isNotEmpty((Collection)(categoryList = this.categoryMapper.selectCategoryList(Integer.valueOf(3), mall)))) {
                allCategoryIdList = categoryList.stream().map(CategoryPO::getCategoryId).collect(Collectors.toList());
            }
        } else {
            allCategoryIdList = categoryIdList;
        }
        return allCategoryIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIP() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.redisHelper.get("instanceId") == null) {
                    this.redisHelper.set("instanceId", (Object)this.instanceId, 300L);
                    DefaultAcsClient client = AliApiUtil.createClient();
                    SpiderEipPO eipPO = this.spiderEipMapper.selectByPrimaryKey(this.instanceId);
                    if (eipPO != null) {
                        String oldEIP = eipPO.getEip();
                        boolean flag = AliApiUtil.describeEipAddresses(client, oldEIP);
                        if (flag) {
                            AliApiUtil.unassociateEipAddres(client, oldEIP);
                            TimeUnit.SECONDS.sleep(5L);
                        }
                        AllocateEipAddressResponse response = AliApiUtil.allocateEipAddress(client);
                        String newEIp = response.getAllocationId();
                        String newIPAdress = response.getEipAddress();
                        AliApiUtil.associateEipAddress(client, newEIp);
                        SpiderEipPO newEipPO = new SpiderEipPO();
                        newEipPO.setCreateTime(new Date());
                        newEipPO.setEcsId(this.instanceId);
                        newEipPO.setEip(newEIp);
                        newEipPO.setEipAdress(newIPAdress);
                        this.spiderEipMapper.insertSelective(newEipPO);
                        AliApiUtil.releaseEipAddress(client, oldEIP);
                        eipPO.setIsDelete(Byte.valueOf((byte)1));
                        eipPO.setUpdateTime(new Date());
                        this.spiderEipMapper.updateByPrimaryKeySelective(eipPO);
                    } else {
                        log.info("EIp\u914d\u7f6e\u6709\u8bef");
                    }
                } else {
                    log.info("\u5176\u4ed6\u7ebf\u7a0b\u5207\u6362ip");
                }
            }
        }
        catch (Exception e) {
            log.error("\u5207\u6362ip\u5f02\u5e38", (Throwable)e);
            this.redisHelper.del(new String[]{"instanceId"});
        }
    }

    public void spiderProduct(DataSkuInfo reqBO) {
        int num;
        String mall = reqBO.getPoolName();
        List skuInfos = reqBO.getData().getSkuInfos();
        String serialNo = reqBO.getSerialNo();
        int lastIndex = num = 100;
        int i = 0;
        while (i < skuInfos.size()) {
            if (lastIndex >= skuInfos.size()) {
                this.spiderDesc(skuInfos.subList(i, skuInfos.size()), mall, serialNo);
                break;
            }
            this.spiderDesc(skuInfos.subList(i, lastIndex), mall, serialNo);
            i = lastIndex;
            lastIndex = i + num;
        }
    }

    private void spiderDesc(List<SkuInfoBO> skuInfos, String mall, String serialNo) {
        for (SkuInfoBO skuInfoBO : skuInfos) {
            String skuId = skuInfoBO.getSkuId();
            String url = skuInfoBO.getExtLink();
            GoodsBO goodsBO = GoodsBO.builder().goodsNo(skuId).prefix(mall).url(url).executionNumber(serialNo).build();
            this.commodityInformationServiceFactory.climbProductDetailsByGoodsNo(goodsBO);
        }
    }

    public Rsp spiderErrorGoodsDetail() {
        List<SkuInfoBO> skuInfos = new ArrayList();
        DataSkuInfo reqBO = new DataSkuInfo();
        ReceiveSkuInfo data = new ReceiveSkuInfo();
        try {
            for (MallType value : MallType.values()) {
                skuInfos.clear();
                List goodsList = this.syncLogMapper.selectByState(value.getCode(), new Date(), null);
                if (!CollectionUtils.isNotEmpty((Collection)goodsList)) continue;
                for (SpiderSyncLogPO syncLogPO : goodsList) {
                    SkuInfoBO skuInfoBO = new SkuInfoBO();
                    skuInfoBO.setExtLink(syncLogPO.getUrl());
                    skuInfoBO.setSkuId(syncLogPO.getGoodsNo());
                    skuInfos.add(skuInfoBO);
                }
                skuInfos = skuInfos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SkuInfoBO>(Comparator.comparing(SkuInfoBO::getSkuId))), ArrayList::new));
                data.setSkuInfos(skuInfos);
                reqBO.setData(data);
                reqBO.setPoolName(value.getCode());
                this.spiderProduct(reqBO);
            }
            log.info("\u722c\u53d6\u6210\u529f:{}" + reqBO);
        }
        catch (Exception e) {
            log.error("\u5546\u57ce\u722c\u53d6\u5931\u8d25reqBO" + reqBO, (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u722c\u53d6\u7ed3\u675f");
        return BaseRspUtils.createSuccessRsp((Object)"\u5546\u57ce\u722c\u53d6\u6210\u529f");
    }

    public Rsp countShop() {
        List sourceInfoPOList = this.dcDataSourceInfoMapper.selectBy();
        if (CollectionUtils.isNotEmpty((Collection)sourceInfoPOList)) {
            for (DcDataSourceInfoPO sourceInfoPO : sourceInfoPOList) {
                this.countMallData(sourceInfoPO);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private Rsp countMallData(DcDataSourceInfoPO dcDataSourceInfoPO) {
        String mall = dcDataSourceInfoPO.getIdentification();
        try {
            if (dcDataSourceInfoPO != null && StringUtils.isNotEmpty((CharSequence)mall)) {
                long numberCategory = this.categoryMapper.selectCountCategoryId(mall);
                long numberCg = this.goodsMapper.selectCountCategoryId(mall);
                long numberGood = this.goodsMapper.selectCountGoods(mall);
                long numberGp0 = this.goodsMapper.selectCountGoodsWithPrice(mall);
                long numberGp = numberGood - numberGp0;
                long number_ge = this.goodsDetailsMapper.selectCountByComment(mall);
                dcDataSourceInfoPO.setNumberCategory(Long.valueOf(numberCategory));
                dcDataSourceInfoPO.setNumberCg(Long.valueOf(numberCg));
                dcDataSourceInfoPO.setNumberGood(Long.valueOf(numberGood));
                dcDataSourceInfoPO.setNumberGe(Long.valueOf(number_ge));
                dcDataSourceInfoPO.setNumberGp(Long.valueOf(numberGp));
                this.dcDataSourceInfoMapper.updateByPrimaryKeySelective(dcDataSourceInfoPO);
            }
        }
        catch (Exception e) {
            log.info("\u7edf\u8ba1\u5546\u57ce{}\u6570\u636e\u5f02\u5e38", (Object)mall, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    @Async(value="klp")
    public Rsp executionTask() {
        log.info("\u4efb\u52a1\u5f00\u59cb");
        this.exeUnexecutedTask();
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exeUnexecutedTask() {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginTime = format.format(new Date());
        List dcTaskList = this.dcTaskExecutionInfoMapper.selectByBeginTime(beginTime, "1");
        if (CollectionUtils.isEmpty((Collection)dcTaskList)) {
            dcTaskList = this.dcTaskExecutionInfoMapper.selectByBeginTime(beginTime, "2");
        }
        if (CollectionUtils.isNotEmpty((Collection)dcTaskList)) {
            this.dcTaskExecutionInfoMapper.updateById(dcTaskList);
            for (DcTaskExecutionInfoPO dcTaskExecutionInfoPO : dcTaskList) {
                String executionNumber = dcTaskExecutionInfoPO.getExecutionNumber();
                Integer exId = dcTaskExecutionInfoPO.getExecutionId();
                RLock lock = null;
                try {
                    DcCrawlOptionsInfoPO optionsInfoPO;
                    SpiderBO spiderBO;
                    String mall;
                    lock = this.redissonClient.getLock(executionNumber);
                    boolean isLock = lock.tryLock();
                    if (!isLock || !StringUtils.isNotEmpty((CharSequence)(mall = dcTaskExecutionInfoPO.getMallLogo()))) continue;
                    mall = mall.trim();
                    if (dcTaskExecutionInfoPO.getCrawlMode().equals("1")) {
                        DcCrawlOptionsInfoPO categoryIds = this.dcCrawlOptionsInfoMapper.selectCategory(mall, executionNumber);
                        if (categoryIds != null) {
                            spiderBO = new SpiderBO();
                            spiderBO.setMall(mall);
                            spiderBO.setCategoryId(categoryIds.getCategoryId());
                            spiderBO.setExecutionNumber(executionNumber);
                            DcTemplateInfoPOWithBLOBs templateInfo = this.dcTemplateInfoMapper.selectBySource(mall, Integer.valueOf(2));
                            if (templateInfo != null) {
                                this.spiderTempService.spiderGoodsList(spiderBO);
                            } else {
                                this.commodityInformationServiceFactory.climbCommodityTabulate(spiderBO);
                            }
                            categoryIds.setExecutionId(exId);
                            categoryIds.setExecutionStatus("1");
                            categoryIds.setMall(mall);
                            this.dcCrawlOptionsInfoMapper.updateByOptionId(categoryIds);
                        }
                    } else if (dcTaskExecutionInfoPO.getCrawlMode().equals("2")) {
                        DcCrawlOptionsInfoPO keyword = this.dcCrawlOptionsInfoMapper.selectSearchTerm(mall, executionNumber);
                        if (keyword != null) {
                            spiderBO = new SpiderBO();
                            spiderBO.setMall(mall.trim());
                            spiderBO.setKeyword(keyword.getSearchTerm());
                            spiderBO.setExecutionNumber(executionNumber);
                            DcTemplateInfoPOWithBLOBs templateInfo = this.dcTemplateInfoMapper.selectBySource(mall, Integer.valueOf(4));
                            if (templateInfo != null) {
                                this.spiderTempService.spiderGoodsBykeyword(spiderBO);
                            } else if (mall.equals("unsplash")) {
                                this.redisService.unsplash(keyword.getSearchTerm());
                            } else {
                                this.commodityInformationServiceFactory.climbProductDetailsByKeyword(spiderBO);
                            }
                            keyword.setExecutionId(exId);
                            keyword.setExecutionStatus("1");
                            keyword.setMall(mall);
                            this.dcCrawlOptionsInfoMapper.updateByOptionId(keyword);
                        }
                    } else if (dcTaskExecutionInfoPO.getCrawlMode().equals("3") && (optionsInfoPO = this.dcCrawlOptionsInfoMapper.selectGoodsNo(mall, executionNumber)) != null) {
                        GoodsBO goodsBO = GoodsBO.builder().goodsNo(optionsInfoPO.getProductCode()).prefix(mall).url(optionsInfoPO.getUrl()).build();
                        goodsBO.setExecutionNumber(executionNumber);
                        DcTemplateInfoPOWithBLOBs templateInfo = this.dcTemplateInfoMapper.selectBySource(mall, Integer.valueOf(3));
                        if (templateInfo != null) {
                            this.spiderTempService.spiderGoodsDetails(goodsBO);
                        } else {
                            this.commodityInformationServiceFactory.climbProductDetailsByGoodsNo(goodsBO);
                        }
                        optionsInfoPO.setExecutionId(exId);
                        optionsInfoPO.setExecutionStatus("1");
                        optionsInfoPO.setMall(mall);
                        this.dcCrawlOptionsInfoMapper.updateByOptionId(optionsInfoPO);
                    }
                    long endTime = System.currentTimeMillis();
                    long exeTime = endTime - startTime;
                    this.updateTaskExe(mall, executionNumber, exeTime, dcTaskExecutionInfoPO);
                }
                catch (Exception e) {
                    log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
                }
                finally {
                    if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    public Rsp executionErrorTask(SpiderBO spiderBO) {
        long startTime = System.currentTimeMillis();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List spiderSyncLogPOS = this.syncLogMapper.selectByExecutionNumber(executionNumber);
            if (CollectionUtils.isNotEmpty((Collection)spiderSyncLogPOS)) {
                String mall = ((SpiderSyncLogPO)spiderSyncLogPOS.get(0)).getSign();
                String spiderType = ((SpiderSyncLogPO)spiderSyncLogPOS.get(0)).getSpiderType();
                for (SpiderSyncLogPO logPO : spiderSyncLogPOS) {
                    if (!StringUtils.isNotEmpty((CharSequence)logPO.getReqBody())) continue;
                    this.syncLogMapper.deleteByPrimaryKey(logPO.getPid());
                    if (spiderType.equals("1")) {
                        spiderBO = (SpiderBO)JSONObject.parseObject((String)logPO.getReqBody(), SpiderBO.class);
                        this.commodityInformationServiceFactory.climbCommodityTabulate(spiderBO);
                    }
                    if (spiderType.equals("1_2")) {
                        spiderBO = (SpiderBO)JSONObject.parseObject((String)logPO.getReqBody(), SpiderBO.class);
                        this.commodityInformationServiceFactory.climbProductDetailsWithCategoryId(spiderBO);
                    }
                    if (spiderType.equals("2")) {
                        spiderBO = (SpiderBO)JSONObject.parseObject((String)logPO.getReqBody(), SpiderBO.class);
                        this.commodityInformationServiceFactory.climbProductDetailsByKeyword(spiderBO);
                    }
                    if (!logPO.getSpiderType().equals("3")) continue;
                    GoodsBO goodsBO = (GoodsBO)JSONObject.parseObject((String)logPO.getReqBody(), GoodsBO.class);
                    this.commodityInformationServiceFactory.climbProductDetailsByGoodsNo(goodsBO);
                }
                long endTime = System.currentTimeMillis();
                long exeTime = endTime - startTime;
                DcTaskExecutionInfoPO dcTaskExecutionInfoPO = new DcTaskExecutionInfoPO();
                this.updateTaskExe(mall, executionNumber, exeTime, dcTaskExecutionInfoPO);
            }
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp querySkuByTaskNumber(QuerySkuByTaskNumberReqBO reqBO) {
        List goodsList = new ArrayList();
        try {
            goodsList = this.goodsMapper.selectSkuByexecutionNumber(reqBO.getPoolName(), reqBO.getTaskNumber());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5f02\u5e38");
        }
        return BaseRspUtils.createSuccessRsp(goodsList);
    }

    private void updateTaskExe(String mall, String executionNumber, Long exeTime, DcTaskExecutionInfoPO dcTaskExecutionInfoPO) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int errorNum = this.syncLogMapper.selectCountByState(mall, executionNumber);
        dcTaskExecutionInfoPO.setEndTime(format.format(new Date()));
        dcTaskExecutionInfoPO.setDataVolume(Integer.valueOf(0));
        dcTaskExecutionInfoPO.setCategoryNums(Integer.valueOf(0));
        dcTaskExecutionInfoPO.setExecutionDuration(ProcessRegexUtil.millisecondsConvertToDHMS(exeTime));
        if (errorNum > 0) {
            if (dcTaskExecutionInfoPO.getExecuteNum() != null && dcTaskExecutionInfoPO.getExecuteNum() < 3) {
                dcTaskExecutionInfoPO.setStatus("1");
                dcTaskExecutionInfoPO.setExecuteNum(Integer.valueOf(dcTaskExecutionInfoPO.getExecuteNum() + 1));
            } else {
                dcTaskExecutionInfoPO.setStatus("6");
            }
        } else {
            dcTaskExecutionInfoPO.setStatus("4");
        }
        if (!dcTaskExecutionInfoPO.getStatus().equals("1")) {
            this.executorService.submit(() -> {
                try {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("executionNumber", executionNumber);
                    if (errorNum > 0) {
                        param.put("status", "0");
                    } else {
                        param.put("status", "1");
                    }
                    String resultStr = JSON.toJSONString(param);
                    HttpResponse httpResponse = HttpRequest.post((String)this.tascrawlkurl).body(resultStr, "application/json").execute();
                    log.info(httpResponse.body());
                }
                catch (Exception e) {
                    log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
                }
            });
        } else {
            this.dcTaskExecutionInfoMapper.updateByPrimaryKeySelective(dcTaskExecutionInfoPO);
        }
    }

    public Rsp spiderGoodsListByCate(String mall, String extNumber) {
        try {
            SpiderParameterBO reqBO = new SpiderParameterBO();
            reqBO.setMall(mall);
            reqBO.setExtraUrlParam("2");
            List<String> categoryIds = this.querySpiderLog(reqBO);
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                for (String categoryId : categoryIds) {
                    SpiderBO spiderBO = new SpiderBO();
                    spiderBO.setExecutionNumber(extNumber);
                    spiderBO.setMall(mall);
                    spiderBO.setCategoryId(categoryId);
                    this.spiderTempService.spiderGoodsList(spiderBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u722c\u53d6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp spiderUnsplashPic(KeywordReqBO reqBO) {
        List keywordReqBOS = reqBO.getKeywordReqBOList();
        if (CollectionUtils.isNotEmpty((Collection)keywordReqBOS)) {
            for (QueryGoodByKeywordReqBO keyword : keywordReqBOS) {
                this.redisService.unsplash(keyword.getKeyword());
            }
        }
        return null;
    }
}

